/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.sparql;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.ExprVisitorFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.RecursiveElementVisitor;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLSyntaxChecker {
    public static List<String> checkQuery(Query query, final Set<String> preBoundVars) {
        final LinkedList<String> results = new LinkedList<String>();
        RecursiveElementVisitor elementVisitor = new RecursiveElementVisitor((ElementVisitor)new ElementVisitorBase()){

            public void startElement(ElementBind el) {
                if (!(!preBoundVars.contains(el.getVar().getVarName()) || SH.valueVar.getVarName().equals(el.getVar().getVarName()) && el.getExpr().isVariable() && el.getExpr().asVar().equals((Object)SH.thisVar))) {
                    results.add("Query must not reassign the pre-bound variable " + el.getVar() + " in a BIND clause");
                }
            }

            public void startElement(ElementData el) {
                results.add("Query must not contain VALUES clause");
            }

            public void startElement(ElementFilter el) {
                this.checkExpression(el.getExpr());
            }

            public void startElement(ElementMinus el) {
                results.add("Query must not contain MINUS clause");
            }

            public void startElement(ElementService el) {
                results.add("Query must not contain SERVICE clause");
            }

            public void startElement(ElementSubQuery el) {
                if (el.getQuery().isQueryResultStar()) {
                    LinkedHashSet queryVars = new LinkedHashSet();
                    PatternVars.vars(queryVars, (Element)el.getQuery().getQueryPattern());
                    for (String varName : preBoundVars) {
                        if (SH.currentShapeVar.getVarName().equals(varName) || SH.shapesGraphVar.getVarName().equals(varName) || queryVars.contains(Var.alloc((String)varName))) continue;
                        results.add("Sub-query must return all potentially pre-bound variables including $" + varName);
                    }
                } else {
                    VarExprList project = el.getQuery().getProject();
                    for (String varName : preBoundVars) {
                        if (SH.currentShapeVar.getVarName().equals(varName) || SH.shapesGraphVar.getVarName().equals(varName) || project.contains(Var.alloc((String)varName))) continue;
                        results.add("Sub-query must return all potentially pre-bound variables including $" + varName);
                    }
                }
            }

            private void checkExpression(Expr expr) {
                1 parent = this;
                expr.visit((ExprVisitor)new ExprVisitorFunction((ElementVisitor)parent){
                    final /* synthetic */ ElementVisitor val$parent;
                    {
                        this.val$parent = elementVisitor;
                    }

                    public void visit(ExprFunctionOp funcOp) {
                        if (funcOp.isGraphPattern()) {
                            funcOp.getElement().visit(this.val$parent);
                        }
                    }

                    public void visit(NodeValue nv) {
                    }

                    public void visit(ExprVar nv) {
                    }

                    public void visit(ExprAggregator eAgg) {
                    }

                    public void visit(ExprNone exprNone) {
                    }

                    protected void visitExprFunction(ExprFunction func) {
                        for (Expr expr : func.getArgs()) {
                            expr.visit((ExprVisitor)this);
                        }
                    }
                });
            }
        };
        query.getQueryPattern().visit((ElementVisitor)elementVisitor);
        return results;
    }
}

