/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.topbraid.spin.model.SPINResource;
import org.topbraid.spin.util.JenaUtil;

public class SPINResourceImpl
extends ResourceImpl
implements SPINResource {
    public SPINResourceImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    public Integer getInteger(Property predicate) {
        return JenaUtil.getIntegerProperty(this, predicate);
    }

    @Override
    public Literal getLiteral(Property predicate) {
        Statement s = this.getProperty(predicate);
        if (s != null && s.getObject().isLiteral()) {
            return s.getLiteral();
        }
        return null;
    }

    @Override
    public Long getLong(Property predicate) {
        Literal literal = this.getLiteral(predicate);
        if (literal != null) {
            return literal.getLong();
        }
        return null;
    }

    @Override
    public RDFNode getRDFNode(Property predicate) {
        Statement s = this.getProperty(predicate);
        if (s != null) {
            return s.getObject();
        }
        return null;
    }

    @Override
    public Resource getResource(Property predicate) {
        Statement s = this.getProperty(predicate);
        if (s != null && s.getObject().isResource()) {
            return s.getResource();
        }
        return null;
    }

    @Override
    public String getString(Property predicate) {
        Statement s = this.getProperty(predicate);
        if (s != null && s.getObject().isLiteral()) {
            return s.getString();
        }
        return null;
    }

    public RDFNode inferRDFNode(Property predicate) {
        RDFNode existing = this.getRDFNode(predicate);
        if (existing != null) {
            return existing;
        }
        return null;
    }
}

