/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.visitor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.FunctionCall;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.visitor.AbstractElementVisitor;
import org.topbraid.spin.model.visitor.AbstractExpressionVisitor;
import org.topbraid.spin.model.visitor.ElementWalker;
import org.topbraid.spin.system.SPINModuleRegistry;
import org.topbraid.spin.util.SPINUtil;
import org.topbraid.spin.vocabulary.SPIN;

public abstract class AbstractTriplesVisitor {
    private Map<Property, RDFNode> bindings;
    private Element element;

    public AbstractTriplesVisitor(Element element, Map<Property, RDFNode> initialBindings) {
        this.bindings = initialBindings;
        this.element = element;
    }

    public void run() {
        ElementWalker walker = new ElementWalker(new MyElementVisitor(), new MyExpressionVisitor());
        this.element.visit(walker);
    }

    protected abstract void handleTriplePattern(TriplePattern var1, Map<Property, RDFNode> var2);

    private class MyExpressionVisitor
    extends AbstractExpressionVisitor {
        private Set<FunctionCall> reachedFunctionCalls = new HashSet<FunctionCall>();

        private MyExpressionVisitor() {
        }

        @Override
        public void visit(FunctionCall functionCall) {
            Resource function = functionCall.getFunction();
            if (function != null && function.isURIResource() && !this.reachedFunctionCalls.contains(functionCall)) {
                Statement bodyS;
                this.reachedFunctionCalls.add(functionCall);
                Function f = SPINModuleRegistry.get().getFunction(function.getURI(), null);
                if (f != null && (bodyS = f.getProperty(SPIN.body)) != null && bodyS.getObject().isResource()) {
                    Query spinQuery;
                    ElementList where;
                    Map oldBindings = AbstractTriplesVisitor.this.bindings;
                    AbstractTriplesVisitor.this.bindings = functionCall.getArgumentsMap();
                    if (oldBindings != null) {
                        Map<String, RDFNode> varNamesBindings = SPINUtil.mapProperty2VarNames(oldBindings);
                        SPINUtil.applyBindings(AbstractTriplesVisitor.this.bindings, varNamesBindings);
                    }
                    if ((where = (spinQuery = SPINFactory.asQuery(bodyS.getResource())).getWhere()) != null) {
                        ElementWalker walker = new ElementWalker(new MyElementVisitor(), this);
                        where.visit(walker);
                    }
                    AbstractTriplesVisitor.this.bindings = oldBindings;
                }
            }
        }
    }

    private class MyElementVisitor
    extends AbstractElementVisitor {
        private MyElementVisitor() {
        }

        @Override
        public void visit(TriplePattern triplePattern) {
            AbstractTriplesVisitor.this.handleTriplePattern(triplePattern, AbstractTriplesVisitor.this.bindings);
        }
    }
}

