/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.update.Update;

public class UpdateUtil {
    public static Collection<Graph> getUpdatedGraphs(Update update, DatasetGraph dsg, Map<String, RDFNode> templateBindings) {
        HashSet<Graph> results = new HashSet<Graph>();
        if (update instanceof UpdateModify) {
            UpdateUtil.addUpdatedGraphs(results, (UpdateModify)update, dsg, templateBindings);
        } else if (update instanceof UpdateDeleteWhere) {
            UpdateUtil.addUpdatedGraphs(results, (UpdateDeleteWhere)update, dsg, templateBindings);
        }
        return results;
    }

    private static void addUpdatedGraphs(Set<Graph> results, UpdateDeleteWhere update, DatasetGraph dsg, Map<String, RDFNode> templateBindings) {
        UpdateUtil.addUpdatedGraphs(results, update.getQuads(), dsg, templateBindings);
    }

    private static void addUpdatedGraphs(Set<Graph> results, UpdateModify update, DatasetGraph dsg, Map<String, RDFNode> templateBindings) {
        Node withIRI = update.getWithIRI();
        if (withIRI != null) {
            results.add(dsg.getGraph(withIRI));
        }
        UpdateUtil.addUpdatedGraphs(results, update.getDeleteQuads(), dsg, templateBindings);
        UpdateUtil.addUpdatedGraphs(results, update.getInsertQuads(), dsg, templateBindings);
    }

    private static void addUpdatedGraphs(Set<Graph> results, Iterable<Quad> quads, DatasetGraph dsg, Map<String, RDFNode> templateBindings) {
        for (Quad quad : quads) {
            if (quad.isDefaultGraph()) {
                results.add(dsg.getDefaultGraph());
                continue;
            }
            if (quad.getGraph().isVariable()) {
                String varName;
                RDFNode binding;
                if (templateBindings == null || (binding = templateBindings.get(varName = quad.getGraph().getName())) == null || !binding.isURIResource()) continue;
                results.add(dsg.getGraph(binding.asNode()));
                continue;
            }
            Graph graph = dsg.getGraph(quad.getGraph());
            if (graph == null) {
                throw new IllegalArgumentException("Cannot resolve named graph " + quad.getGraph().getURI());
            }
            results.add(graph);
        }
    }
}

