/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;

public class TransformPromoteTableEmpty
extends TransformCopy {
    @Override
    public Op transform(OpGraph opGraph, Op subOp) {
        if (this.isTableEmpty(subOp)) {
            return subOp;
        }
        return super.transform(opGraph, subOp);
    }

    @Override
    public Op transform(OpAssign opAssign, Op subOp) {
        if (this.isTableEmpty(subOp)) {
            return subOp;
        }
        return super.transform(opAssign, subOp);
    }

    @Override
    public Op transform(OpExtend opExtend, Op subOp) {
        if (this.isTableEmpty(subOp)) {
            return subOp;
        }
        return super.transform(opExtend, subOp);
    }

    @Override
    public Op transform(OpJoin opJoin, Op left, Op right) {
        if (this.isTableEmpty(left) || this.isTableEmpty(right)) {
            return OpTable.empty();
        }
        return super.transform(opJoin, left, right);
    }

    @Override
    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        if (this.isTableEmpty(left)) {
            return OpTable.empty();
        }
        if (this.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opLeftJoin, left, right);
    }

    @Override
    public Op transform(OpMinus opMinus, Op left, Op right) {
        if (this.isTableEmpty(left)) {
            return OpTable.empty();
        }
        if (this.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opMinus, left, right);
    }

    @Override
    public Op transform(OpUnion opUnion, Op left, Op right) {
        if (this.isTableEmpty(left)) {
            if (this.isTableEmpty(right)) {
                return OpTable.empty();
            }
            return right;
        }
        if (this.isTableEmpty(right)) {
            return left;
        }
        return super.transform(opUnion, left, right);
    }

    private boolean isTableEmpty(Op op) {
        if (op instanceof OpTable) {
            return ((OpTable)op).getTable().isEmpty();
        }
        return false;
    }
}

