/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMap;
import org.apache.jena.sparql.core.DatasetGraphMapLink;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.core.mem.DatasetGraphInMemory;
import org.apache.jena.sparql.graph.GraphFactory;

public class DatasetGraphFactory {
    public static GraphMaker graphMakerNull = () -> null;
    public static GraphMaker graphMakerMem = () -> GraphFactory.createDefaultGraph();

    public static DatasetGraph create() {
        return new DatasetGraphMap();
    }

    public static DatasetGraph createGeneral() {
        return new DatasetGraphMapLink(graphMakerMem);
    }

    public static DatasetGraph createTxnMem() {
        return new DatasetGraphInMemory();
    }

    @Deprecated
    public static DatasetGraph createMem() {
        return DatasetGraphFactory.createGeneral();
    }

    @Deprecated
    public static DatasetGraph create(DatasetGraph dsg) {
        return DatasetGraphFactory.cloneStructure(dsg);
    }

    public static DatasetGraph cloneStructure(DatasetGraph dsg) {
        DatasetGraphMapLink dsg2 = new DatasetGraphMapLink(dsg.getDefaultGraph());
        Iterator<Node> names = dsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsg2.addGraph(gn, dsg.getGraph(gn));
        }
        return dsg2;
    }

    private static void copyOver(DatasetGraph dsgDest, DatasetGraph dsgSrc) {
        dsgDest.setDefaultGraph(dsgSrc.getDefaultGraph());
        Iterator<Node> names = dsgSrc.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsgDest.addGraph(gn, dsgSrc.getGraph(gn));
        }
    }

    public static DatasetGraph create(Graph graph) {
        return new DatasetGraphMapLink(graph);
    }

    public static DatasetGraph createOneGraph(Graph graph) {
        return new DatasetGraphOne(graph);
    }

    public static interface GraphMaker {
        public Graph create();
    }
}

