/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.util.graph.GraphList;

public abstract class ListBase
extends PropertyFunctionEval {
    private PropFuncArgType objFuncArgType;

    public ListBase(PropFuncArgType objFuncArgType) {
        super(PropFuncArgType.PF_ARG_SINGLE, objFuncArgType);
    }

    @Override
    public final QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Node listNode = argSubject.getArg();
        if (!Var.isVar(listNode)) {
            return this.execOneList(binding, listNode, predicate, argObject, execCxt);
        }
        Var listVar = Var.alloc(listNode);
        return this.listUnboundSubject(binding, listVar, predicate, argObject, execCxt);
    }

    private QueryIterator listUnboundSubject(Binding binding, Var listVar, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (argObject.isList()) {
            List<Node> objectArgs = argObject.getArgList();
            return this.execObjectList(binding, listVar, predicate, objectArgs, execCxt);
        }
        Node obj = argObject.getArg();
        if (Var.isVar(obj)) {
            Graph graph = execCxt.getActiveGraph();
            Set<Node> x = GraphList.findAllLists(graph);
            return this.allLists(binding, x, listVar, obj, argObject, execCxt);
        }
        return this.execObjectBound(binding, listVar, predicate, obj, execCxt);
    }

    protected QueryIterator allLists(Binding binding, Collection<Node> x, Var listVar, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterConcat qIter = new QueryIterConcat(execCxt);
        for (Node n : x) {
            Binding b = BindingFactory.binding(binding, listVar, n);
            QueryIterator q = this.execOneList(b, n, predicate, argObject, execCxt);
            qIter.add(q);
        }
        return qIter;
    }

    protected abstract QueryIterator execObjectBound(Binding var1, Var var2, Node var3, Node var4, ExecutionContext var5);

    protected abstract QueryIterator execObjectList(Binding var1, Var var2, Node var3, List<Node> var4, ExecutionContext var5);

    protected abstract QueryIterator execOneList(Binding var1, Node var2, Node var3, PropFuncArg var4, ExecutionContext var5);
}

