/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.sparql.util.RomanNumeral;

public class RomanNumeralDatatype
extends BaseDatatype {
    private static boolean firstClassDatatype = false;
    private static RomanNumeralDatatype datatype = new RomanNumeralDatatype();
    private static final String URI = "http://rome.example.org/Numeral";

    public static void enableAsFirstClassDatatype() {
        if (!firstClassDatatype) {
            TypeMapper.getInstance().registerDatatype((RDFDatatype)RomanNumeralDatatype.get());
        }
    }

    public static RomanNumeralDatatype get() {
        return datatype;
    }

    private RomanNumeralDatatype() {
        super(URI);
    }

    public Class<?> getJavaClass() {
        return RomanNumeral.class;
    }

    public String unparse(Object value) {
        return value.toString();
    }

    public Object parse(String lexicalForm) throws DatatypeFormatException {
        try {
            return RomanNumeral.r2i(lexicalForm);
        }
        catch (NumberFormatException ex) {
            throw new DatatypeFormatException(lexicalForm, (RDFDatatype)this, ex.getMessage());
        }
    }

    public String toString() {
        return "Roman Numeral";
    }
}

