/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public final class DirectByteBufferDeallocator {
    private static final boolean SUPPORTED;
    private static final Method cleaner;
    private static final Method cleanerClean;

    private DirectByteBufferDeallocator() {
    }

    public static void free(ByteBuffer buffer) {
        if (SUPPORTED && buffer != null && buffer.isDirect()) {
            try {
                Object cleaner = DirectByteBufferDeallocator.cleaner.invoke((Object)buffer, new Object[0]);
                cleanerClean.invoke(cleaner, new Object[0]);
            }
            catch (Throwable t) {
                UndertowLogger.ROOT_LOGGER.directBufferDeallocationFailed(t);
            }
        }
    }

    static {
        boolean supported;
        Method tmpCleaner = null;
        Method tmpCleanerClean = null;
        try {
            tmpCleaner = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            tmpCleaner.setAccessible(true);
            tmpCleanerClean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            tmpCleanerClean.setAccessible(true);
            supported = true;
        }
        catch (Throwable t) {
            UndertowLogger.ROOT_LOGGER.directBufferDeallocatorInitializationFailed(t);
            supported = false;
        }
        SUPPORTED = supported;
        cleaner = tmpCleaner;
        cleanerClean = tmpCleanerClean;
    }
}

