/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.proxy;

import io.undertow.UndertowMessages;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.OpenListener;
import io.undertow.util.PooledAdaptor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.charset.StandardCharsets;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.SslConnection;

class ProxyProtocolReadListener
implements ChannelListener<StreamSourceChannel> {
    private static final int MAX_HEADER_LENGTH = 107;
    private static final byte[] NAME = "PROXY ".getBytes(StandardCharsets.US_ASCII);
    private static final String UNKNOWN = "UNKNOWN";
    private static final String TCP = "TCP";
    private static final String TCP_6 = "TCP6";
    private final StreamConnection streamConnection;
    private final OpenListener openListener;
    private final UndertowXnioSsl ssl;
    private final ByteBufferPool bufferPool;
    private final OptionMap sslOptionMap;
    private int byteCount;
    private String protocol;
    private InetAddress sourceAddress;
    private InetAddress destAddress;
    private int sourcePort = -1;
    private int destPort = -1;
    private StringBuilder stringBuilder = new StringBuilder();
    private boolean carriageReturnSeen = false;
    private boolean parsingUnknown = false;

    ProxyProtocolReadListener(StreamConnection streamConnection, OpenListener openListener, UndertowXnioSsl ssl, ByteBufferPool bufferPool, OptionMap sslOptionMap) {
        this.streamConnection = streamConnection;
        this.openListener = openListener;
        this.ssl = ssl;
        this.bufferPool = bufferPool;
        this.sslOptionMap = sslOptionMap;
        if (bufferPool.getBufferSize() < 107) {
            throw UndertowMessages.MESSAGES.bufferPoolTooSmall(107);
        }
    }

    /*
     * Exception decompiling
     */
    public void handleEvent(StreamSourceChannel streamSourceChannel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP], 16[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void proxyAccept(SocketAddress source, SocketAddress dest, PooledByteBuffer additionalData) {
        StreamConnection streamConnection = this.streamConnection;
        if (source != null) {
            streamConnection = new AddressWrappedConnection(streamConnection, source, dest);
        }
        if (this.ssl != null) {
            if (additionalData != null) {
                PushBackStreamSourceConduit conduit = new PushBackStreamSourceConduit(streamConnection.getSourceChannel().getConduit());
                conduit.pushBack((Pooled)new PooledAdaptor(additionalData));
                streamConnection.getSourceChannel().setConduit((StreamSourceConduit)conduit);
            }
            SslConnection sslConnection = this.ssl.wrapExistingConnection(streamConnection, this.sslOptionMap == null ? OptionMap.EMPTY : this.sslOptionMap);
            UndertowXnioSsl.getSslEngine(sslConnection).setUseClientMode(false);
            streamConnection = sslConnection;
            this.callOpenListener(streamConnection, null);
        } else {
            this.callOpenListener(streamConnection, additionalData);
        }
    }

    private void callOpenListener(StreamConnection streamConnection, PooledByteBuffer buffer) {
        if (this.openListener instanceof DelegateOpenListener) {
            ((DelegateOpenListener)this.openListener).handleEvent(streamConnection, buffer);
        } else {
            if (buffer != null) {
                PushBackStreamSourceConduit conduit = new PushBackStreamSourceConduit(streamConnection.getSourceChannel().getConduit());
                conduit.pushBack((Pooled)new PooledAdaptor(buffer));
                streamConnection.getSourceChannel().setConduit((StreamSourceConduit)conduit);
            }
            this.openListener.handleEvent((Channel)streamConnection);
        }
    }

    static InetAddress parseAddress(String addressString, String protocol) throws IOException {
        InetAddress address;
        if (protocol.equals(TCP)) {
            String[] parts = addressString.split("\\.");
            if (parts.length != 4) {
                throw UndertowMessages.MESSAGES.invalidProxyHeader();
            }
            byte[] data = new byte[4];
            for (int i = 0; i < 4; ++i) {
                String part = parts[i];
                if (part.length() == 0 || part.charAt(0) == '0' && part.length() > 1) {
                    throw UndertowMessages.MESSAGES.invalidProxyHeader();
                }
                data[i] = (byte)Integer.parseInt(part);
            }
            address = InetAddress.getByAddress(data);
        } else {
            boolean startsWithColon = addressString.startsWith(":");
            if (startsWithColon && !addressString.startsWith("::")) {
                throw UndertowMessages.MESSAGES.invalidProxyHeader();
            }
            String[] parts = (startsWithColon ? addressString.substring(1) : addressString).split(":");
            byte[] data = new byte[16];
            int partOffset = 0;
            boolean seenEmpty = false;
            if (parts.length > 8) {
                throw UndertowMessages.MESSAGES.invalidProxyHeader();
            }
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.length() > 4) {
                    throw UndertowMessages.MESSAGES.invalidProxyHeader();
                }
                if (part.isEmpty()) {
                    if (seenEmpty) {
                        throw UndertowMessages.MESSAGES.invalidProxyHeader();
                    }
                    seenEmpty = true;
                    int off = 8 - parts.length;
                    if (off < 0) {
                        throw UndertowMessages.MESSAGES.invalidProxyHeader();
                    }
                    partOffset = off * 2;
                    continue;
                }
                if (part.length() > 1 && part.charAt(0) == '0') {
                    throw UndertowMessages.MESSAGES.invalidProxyHeader();
                }
                int num = Integer.parseInt(part, 16);
                data[i * 2 + partOffset] = (byte)(num >> 8);
                data[i * 2 + partOffset + 1] = (byte)num;
            }
            if (parts.length < 8 && !seenEmpty) {
                throw UndertowMessages.MESSAGES.invalidProxyHeader();
            }
            address = InetAddress.getByAddress(data);
        }
        return address;
    }

    private static final class AddressWrappedConnection
    extends StreamConnection {
        private final StreamConnection delegate;
        private final SocketAddress source;
        private final SocketAddress dest;

        AddressWrappedConnection(StreamConnection delegate, SocketAddress source, SocketAddress dest) {
            super(delegate.getIoThread());
            this.delegate = delegate;
            this.source = source;
            this.dest = dest;
            this.setSinkConduit(delegate.getSinkChannel().getConduit());
            this.setSourceConduit(delegate.getSourceChannel().getConduit());
        }

        protected void notifyWriteClosed() {
            IoUtils.safeClose((Closeable)this.delegate.getSinkChannel());
        }

        protected void notifyReadClosed() {
            IoUtils.safeClose((Closeable)this.delegate.getSourceChannel());
        }

        public SocketAddress getPeerAddress() {
            return this.source;
        }

        public SocketAddress getLocalAddress() {
            return this.dest;
        }
    }
}

