import wait as runtimeWait from dw::Runtime
import mergeWith from dw::core::Objects

import HttpClientResult from dw::http::Types
import HttpCustomOptions from dw::http::Client

import * from bat::core::Helpers
import * from bat::Types

import executeStep0, runSequence from bat::core::Executors
import println, red from bat::core::Console

// This file should only contain the DSL of testing. Any other function should be placed in other module(s)

// DSL =================================================================================================================

fun GET(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'GET')

fun POST(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'POST')

fun PUT(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'PUT')

fun PATCH(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'PATCH')

fun OPTIONS(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'OPTIONS')

fun DELETE(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'DELETE')

fun TRACE(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'TRACE')

fun CONNECT(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'CONNECT')

// BDD VOCABULARY ======================================================================================================


fun given(name: String) =
  createNamedBlock("GIVEN", name)

fun xgiven(name: String) =
  createNamedBlock("GIVEN", name, { skip: true })

fun given(parts: Array<String>, interpolation: Array<String>) =
  given(stringInterpolation(parts, interpolation))

fun xgiven(parts: Array<String>, interpolation: Array<String>) =
  xgiven(stringInterpolation(parts, interpolation))




fun when(name: String) =
  createNamedBlock("WHEN", name, { softFail: false })

fun xwhen(name: String) =
  createNamedBlock("WHEN", name, { skip: true, softFail: false })

fun when(parts: Array<String>, interpolation: Array<String>) =
  when(stringInterpolation(parts, interpolation))

fun xwhen(parts: Array<String>, interpolation: Array<String>) =
  xwhen(stringInterpolation(parts, interpolation))




fun describe(name: String) =
  createNamedBlock("DESCRIBE", name)

fun xdescribe(name: String) =
  createNamedBlock("DESCRIBE", name, { skip: true })

fun describe(parts: Array<String>, interpolation: Array<String>) =
  describe(stringInterpolation(parts, interpolation))

fun xdescribe(parts: Array<String>, interpolation: Array<String>) =
  xdescribe(stringInterpolation(parts, interpolation))



fun scenario(name: String) =
  createNamedBlock("SCENARIO", name)

fun xscenario(name: String) =
  createNamedBlock("SCENARIO", name, { skip: true })

fun scenario(parts: Array<String>, interpolation: Array<String>) =
  scenario(stringInterpolation(parts, interpolation))

fun xscenario(parts: Array<String>, interpolation: Array<String>) =
  xscenario(stringInterpolation(parts, interpolation))




fun it(name: String) =
  createNamedBlock("IT", name)

fun xit(name: String) =
  createNamedBlock("IT", name, { skip: true })

fun it(parts: Array<String>, interpolation: Array<String>) =
  it(stringInterpolation(parts, interpolation))

fun xit(parts: Array<String>, interpolation: Array<String>) =
  xit(stringInterpolation(parts, interpolation))



fun suite(name: String) =
  createNamedBlock("SUITE", name)

fun xsuite(name: String) =
  createNamedBlock("SUITE", name, { skip: true })

fun suite(parts: Array<String>, interpolation: Array<String>) =
  suite(stringInterpolation(parts, interpolation))

fun xsuite(parts: Array<String>, interpolation: Array<String>) =
  xsuite(stringInterpolation(parts, interpolation))



fun should<T>(a: (T) -> BATTest, b: T): BATTest = (a(b) mergeWith { prefix: "SHOULD", softFail: true }) as BATTest

fun should(str: String): BATTest = createNamedBlock("SHOULD", str, { softFail: true })
fun xshould(str: String): BATTest = createNamedBlock("SHOULD", str, { skip: true, softFail: true })

fun should(parts: Array<String>, interpolation: Array<String>) = should(stringInterpolation(parts, interpolation))
fun xshould(parts: Array<String>, interpolation: Array<String>) = xshould(stringInterpolation(parts, interpolation))



fun must<T>(a: (T) -> BATTest, b: T): BATTest = (a(b) mergeWith { prefix: "MUST", softFail: false }) as BATTest

fun must(str: String): BATTest = createNamedBlock("MUST", str, { softFail: false })
fun xmust(str: String): BATTest = createNamedBlock("MUST", str, { skip: true, softFail: false })

fun must(parts: Array<String>, interpolation: Array<String>) = must(stringInterpolation(parts, interpolation))
fun xmust(parts: Array<String>, interpolation: Array<String>) = xmust(stringInterpolation(parts, interpolation))




fun assuming(test: BATTest, condition: Boolean) = do {
  var metadata = test.metadata default {} mergeWith { batAssumingCondition: condition }
  ---
  (test mergeWith { skip: not condition, metadata: metadata }) as BATTest
}


fun withTags(test: BATTest | BATHttpStep, tags: Array<String>) = do {
  var originalMetadata = test.metadata default {}
  var metadata = originalMetadata mergeWith { tags: (originalMetadata.tags default []) ++ tags }
  ---
  (test mergeWith { metadata: metadata }) as BATTest
}

fun withId(test: BATTest | BATHttpStep, id: String) = do {
  var originalMetadata = test.metadata default {}
  var metadata = originalMetadata mergeWith { id: id }
  ---
  (test mergeWith { metadata: metadata }) as BATTest
}



fun withTags(test: BATTest, tag: String) = withTags(test, [tag])

fun withTag(test: BATTest, tag: Array<String>) = withTags(test, tag)
fun withTag(test: BATTest, tag: String) = withTags(test, [tag])


fun when(test: BATTest, condition: Boolean) = assuming(test, condition)

fun whenNot(test: BATTest, condition: Boolean) = assuming(test, not condition)



fun in<T>(sequence: BATTest, statements: Array<() -> T>) =
  describeSequence(sequence, statements)


fun sleep(ms: Number) =
  wait(ms)

fun wait(ms: Number) =
  createNamedBlock("Wait", println("Wait $(ms runtimeWait ms)ms."), { kind: "Wait" })


fun repeat(times: Number) =
  createNamedBlock("REPEAT", "Repeat $times times", {
    kind: "LOOPABLE",
    metadata: {
      batLoopable: {
        times: times
      }
    }
  })

fun times<T>(sequence: BATTest, statements: Array<() -> T | Array<T>>) =
  describeSequence(sequence, statements)

fun while<T>(endpointCall: () -> T, condition: (T) -> Boolean, timeBetweenTries: Number = 1000, maxRetries: Number = 3): T = do {
    var result = runtimeWait(endpointCall(), timeBetweenTries)
    ---
    if(condition(result) and maxRetries > 0)
        while(endpointCall, condition, timeBetweenTries, maxRetries - 1)
    else
        result
}

fun until<T>(endpointCall: () -> T, condition: (T) -> Boolean, timeBetweenTries: Number = 1000, maxRetries: Number = 3): T = do {
     var result = runtimeWait(endpointCall(), timeBetweenTries)
    ---
    if(condition(result) or maxRetries == 1)
        result
    else
        until(endpointCall, condition, timeBetweenTries, maxRetries - 1)
}