/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.rules.Rule;
import org.topbraid.shacl.rules.RuleLanguage;
import org.topbraid.shacl.rules.RuleLanguages;
import org.topbraid.shacl.util.OrderComparator;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.progress.ProgressMonitor;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;

public class RuleEngine
implements NodeExpressionContext {
    private Dataset dataset;
    private Model inferences;
    private ProgressMonitor monitor;
    private Set<Triple> pending = new HashSet<Triple>();
    private Map<Rule, List<Resource>> rule2Conditions = new HashMap<Rule, List<Resource>>();
    private ShapesGraph shapesGraph;
    private URI shapesGraphURI;
    private Map<Shape, List<Rule>> shape2Rules = new HashMap<Shape, List<Rule>>();

    public RuleEngine(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, Model inferences) {
        this.dataset = dataset;
        this.inferences = inferences;
        this.shapesGraph = shapesGraph;
        this.shapesGraphURI = shapesGraphURI;
    }

    public void executeAll() throws InterruptedException {
        ArrayList<Shape> ruleShapes = new ArrayList<Shape>();
        for (Shape shape : this.shapesGraph.getRootShapes()) {
            if (!shape.getShapeResource().hasProperty(SH.rule)) continue;
            ruleShapes.add(shape);
        }
        if (ruleShapes.isEmpty()) {
            return;
        }
        Collections.sort(ruleShapes, new Comparator<Shape>(){

            @Override
            public int compare(Shape shape1, Shape shape2) {
                return shape1.getOrder().compareTo(shape2.getOrder());
            }
        });
        String baseMessage = null;
        if (this.monitor != null) {
            int rules = 0;
            for (Shape shape : ruleShapes) {
                rules += this.getShapeRules(shape).size();
            }
            baseMessage = "Executing " + rules + " SHACL rules from " + ruleShapes.size() + " shapes";
            this.monitor.beginTask(baseMessage, rules);
        }
        Double oldOrder = ((Shape)ruleShapes.get(0)).getOrder();
        for (Shape shape : ruleShapes) {
            if (!oldOrder.equals(shape.getOrder())) {
                oldOrder = shape.getOrder();
                this.flushPending();
            }
            this.executeShape(shape, baseMessage);
        }
        this.flushPending();
    }

    public void executeShape(Shape shape, String baseMessage) throws InterruptedException {
        if (shape.getShapeResource().isDeactivated()) {
            return;
        }
        List<Rule> rules = this.getShapeRules(shape);
        if (rules.isEmpty()) {
            return;
        }
        List<RDFNode> targetNodes = SHACLUtil.getTargetNodes(shape.getShapeResource(), this.dataset);
        if (!targetNodes.isEmpty()) {
            Number oldOrder = rules.get(0).getOrder();
            for (Rule rule : rules) {
                List<Resource> conditions;
                if (this.monitor != null) {
                    if (this.monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.monitor.setTaskName(baseMessage + " (at " + SPINLabels.get().getLabel(shape.getShapeResource()) + " with " + targetNodes.size() + " target nodes)");
                    this.monitor.subTask(rule.toString().replace("\n", " "));
                }
                if (!oldOrder.equals(rule.getOrder())) {
                    oldOrder = rule.getOrder();
                    this.flushPending();
                }
                if (!(conditions = this.rule2Conditions.get(rule)).isEmpty()) {
                    LinkedList<RDFNode> filtered = new LinkedList<RDFNode>();
                    for (RDFNode targetNode : targetNodes) {
                        if (!this.nodeConformsToAllShapes(targetNode, conditions)) continue;
                        filtered.add(targetNode);
                    }
                    this.executeRule(rule, filtered, shape);
                } else {
                    this.executeRule(rule, targetNodes, shape);
                }
                if (this.monitor == null) continue;
                this.monitor.worked(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRule(Rule rule, List<RDFNode> focusNodes, Shape shape) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            if (SPINStatisticsManager.get().isRecording()) {
                long startTime = System.currentTimeMillis();
                rule.execute(this, focusNodes, shape);
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                String queryText = rule.toString();
                SPINStatisticsManager.get().add(Collections.singletonList(new SPINStatistics(queryText, queryText, duration, startTime, rule.getResource().asNode())));
            } else {
                rule.execute(this, focusNodes, shape);
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    private void flushPending() {
        for (Triple triple : this.pending) {
            this.inferences.add(this.inferences.asStatement(triple));
        }
        this.pending.clear();
    }

    private List<Rule> getShapeRules(Shape shape) {
        List<Rule> rules = this.shape2Rules.get(shape);
        if (rules == null) {
            rules = new LinkedList<Rule>();
            this.shape2Rules.put(shape, rules);
            LinkedList<Resource> raws = new LinkedList<Resource>();
            for (Statement s : shape.getShapeResource().listProperties(SH.rule).toList()) {
                if (!s.getObject().isResource() || s.getResource().hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE)) continue;
                raws.add(s.getResource());
            }
            Collections.sort(raws, OrderComparator.get());
            for (Resource raw : raws) {
                RuleLanguage ruleLanguage = RuleLanguages.get().getRuleLanguage(raw);
                if (ruleLanguage == null) {
                    throw new IllegalArgumentException("Unsupported SHACL rule type for " + raw);
                }
                Rule rule = ruleLanguage.createRule(raw);
                rules.add(rule);
                List<Resource> conditions = JenaUtil.getResourceProperties(raw, SH.condition);
                this.rule2Conditions.put(rule, conditions);
            }
        }
        return rules;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public Model getInferencesModel() {
        return this.inferences;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public ShapesGraph getShapesGraph() {
        return this.shapesGraph;
    }

    public Model getShapesModel() {
        return this.dataset.getNamedModel(this.shapesGraphURI.toString());
    }

    @Override
    public URI getShapesGraphURI() {
        return this.shapesGraphURI;
    }

    public void infer(Triple triple, Rule rule, Shape shape) {
        this.pending.add(triple);
    }

    private boolean nodeConformsToAllShapes(RDFNode focusNode, Iterable<Resource> shapes) {
        for (Resource shape : shapes) {
            ValidationEngine engine = ValidationEngineFactory.get().create(this.dataset, this.shapesGraphURI, this.shapesGraph, null);
            Resource report = engine.validateNodesAgainstShape(Collections.singletonList(focusNode), shape.asNode());
            if (!report.hasProperty(SH.result)) continue;
            return false;
        }
        return true;
    }

    public void setProgressMonitor(ProgressMonitor value) {
        this.monitor = value;
    }
}

