/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.vocabulary.SP;

public class Aggregations {
    private static Map<String, Resource> name2Type = new HashMap<String, Resource>();
    private static Map<Resource, String> type2Name = new HashMap<Resource, String>();

    public static String getName(Resource aggType) {
        return type2Name.get(aggType);
    }

    public static Resource getType(String name) {
        return name2Type.get(name);
    }

    public static void register(Resource aggType, String name) {
        type2Name.put(aggType, name);
        name2Type.put(name, aggType);
    }

    static {
        Model model = SP.getModel();
        ResIterator it = model.listSubjectsWithProperty(RDFS.subClassOf, (RDFNode)SP.Aggregation);
        while (it.hasNext()) {
            Resource aggType = (Resource)it.next();
            String name = aggType.getProperty(RDFS.label).getString();
            Aggregations.register(aggType, name);
        }
    }
}

