/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.ConduitFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xnio.conduits.StreamSinkConduit;

public class JvmRouteHandler
implements HttpHandler {
    private final HttpHandler next;
    private final String sessionCookieName;
    private final String jvmRoute;
    private final JvmRouteWrapper wrapper = new JvmRouteWrapper();

    public JvmRouteHandler(HttpHandler next, String sessionCookieName, String jvmRoute) {
        this.next = next;
        this.sessionCookieName = sessionCookieName;
        this.jvmRoute = jvmRoute;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        int part;
        Cookie sessionId = exchange.getRequestCookies().get(this.sessionCookieName);
        if (sessionId != null && (part = sessionId.getValue().indexOf(46)) != -1) {
            sessionId.setValue(sessionId.getValue().substring(0, part));
        }
        exchange.addResponseWrapper(this.wrapper);
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String value;
        private final String sessionCookieName;

        private Wrapper(String value, String sessionCookieName) {
            this.value = value;
            this.sessionCookieName = sessionCookieName;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new JvmRouteHandler(handler, this.sessionCookieName, this.value);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "jvm-route";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", String.class);
            params.put("session-cookie-name", String.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            String sessionCookieName = (String)config.get("session-cookie-name");
            return new Wrapper((String)config.get("value"), sessionCookieName == null ? "JSESSIONID" : sessionCookieName);
        }
    }

    private class JvmRouteWrapper
    implements ConduitWrapper<StreamSinkConduit> {
        private JvmRouteWrapper() {
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            Cookie sessionId = exchange.getResponseCookies().get(JvmRouteHandler.this.sessionCookieName);
            if (sessionId != null) {
                StringBuilder sb = new StringBuilder(sessionId.getValue());
                sb.append('.');
                sb.append(JvmRouteHandler.this.jvmRoute);
                sessionId.setValue(sb.toString());
            }
            return factory.create();
        }
    }
}

