/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.Node;

class MCMPInfoUtil {
    private static final String NEWLINE = "\n";

    MCMPInfoUtil() {
    }

    static void printDump(Balancer balancer, StringBuilder builder) {
        builder.append("balancer: [").append(balancer.getId()).append("],").append(" Name: ").append(balancer.getName()).append(" Sticky: ").append(MCMPInfoUtil.formatBoolean(balancer.isStickySession())).append(" [").append(balancer.getStickySessionCookie()).append("]/[").append(balancer.getStickySessionPath()).append("]").append(" remove: ").append(MCMPInfoUtil.formatBoolean(balancer.isStickySessionRemove())).append("force: ").append(MCMPInfoUtil.formatBoolean(balancer.isStickySessionForce())).append("Timeout: ").append(balancer.getWaitWorker()).append("maxAttempts: ").append(balancer.getMaxattempts()).append(NEWLINE);
    }

    static void printInfo(Node.VHostMapping host, StringBuilder builder) {
        builder.append("Vhost: [").append(host.getNode().getId()).append(":").append(host.getId()).append(":").append(-1).append("], Alias: ").append(host.getAliases()).append(NEWLINE);
    }

    static void printDump(Node.VHostMapping host, StringBuilder builder) {
        int hostID = host.getId();
        int nodeID = host.getNode().getId();
        for (String alias : host.getAliases()) {
            builder.append("host: ").append(hostID).append(" [").append(alias).append("] vhost: ").append(host.getId()).append(" node: ").append(nodeID).append(NEWLINE);
        }
    }

    static void printInfo(Context context, StringBuilder builder) {
        builder.append("Context: ").append("[").append(context.getNode().getId()).append(":").append(context.getVhost().getId()).append(":").append(context.getId()).append("]").append("],Context: ").append(context.getPath()).append(",Status: ").append((Object)context.getStatus()).append(NEWLINE);
    }

    static void printDump(Context context, StringBuilder builder) {
        builder.append("context: ").append("[").append(context.getId()).append("]").append(" [").append(context.getPath()).append("] vhost: ").append(context.getVhost().getId()).append("node: ").append(context.getNode().getId()).append("status: ").append((Object)context.getStatus()).append(NEWLINE);
    }

    static void printInfo(Node node, StringBuilder builder) {
        builder.append("Node: [").append(node.getId()).append("]").append(",Name: ").append(node.getJvmRoute()).append(",Balancer: ").append(node.getNodeConfig().getBalancer()).append(",JVMRoute: ").append(node.getJvmRoute()).append(",LBGroup: ").append(node.getNodeConfig().getDomain()).append(",Host: ").append(node.getNodeConfig().getConnectionURI().getHost()).append(",Port: ").append(node.getNodeConfig().getConnectionURI().getPort()).append(",Type: ").append(node.getNodeConfig().getConnectionURI().getScheme()).append(",flushpackets: ").append(MCMPInfoUtil.formatBoolean(node.getNodeConfig().isFlushPackets())).append(",flushwait: ").append(node.getNodeConfig().getFlushwait()).append(",ping: ").append(node.getNodeConfig().getPing()).append(",smax: ").append(node.getNodeConfig().getSmax()).append(",ttl: ").append(node.getNodeConfig().getTtl()).append(",timeout: ").append(node.getNodeConfig().getTimeout()).append(",Elected: ").append(node.getElected()).append(",Read: ").append(node.getConnectionPool().getClientStatistics().getRead()).append(",Transferred: ").append(node.getConnectionPool().getClientStatistics().getWritten()).append(",Connected: ").append(node.getConnectionPool().getOpenConnections()).append(",Load: ").append(node.getLoad()).append(NEWLINE);
    }

    static void printDump(Node node, StringBuilder builder) {
        builder.append("node: [").append(node.getBalancer().getId()).append(":").append(node.getId()).append("]").append(",Balancer: ").append(node.getNodeConfig().getBalancer()).append(",JVMRoute: ").append(node.getJvmRoute()).append(",LBGroup: ").append(node.getNodeConfig().getDomain()).append(",Host: ").append(node.getNodeConfig().getConnectionURI().getHost()).append(",Port: ").append(node.getNodeConfig().getConnectionURI().getPort()).append(",Type: ").append(node.getNodeConfig().getConnectionURI().getScheme()).append(",flushpackets: ").append(MCMPInfoUtil.formatBoolean(node.getNodeConfig().isFlushPackets())).append(",flushwait: ").append(node.getNodeConfig().getFlushwait()).append(",ping: ").append(node.getNodeConfig().getPing()).append(",smax: ").append(node.getNodeConfig().getSmax()).append(",ttl: ").append(node.getNodeConfig().getTtl()).append(",timeout: ").append(node.getNodeConfig().getTimeout()).append(NEWLINE);
    }

    static String formatBoolean(boolean value) {
        return value ? "1" : "0";
    }
}

