/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.expr.AppendContext;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;

public class IntersectionExpression
extends ComplexNodeExpression {
    private List<NodeExpression> inputs;

    public IntersectionExpression(List<NodeExpression> inputs) {
        this.inputs = inputs;
    }

    @Override
    public void appendLabel(AppendContext context, String targetVarName) {
        int i;
        String varName = context.getNextVarName();
        for (i = 0; i < this.inputs.size(); ++i) {
            NodeExpression input = this.inputs.get(i);
            if (input instanceof ComplexNodeExpression) {
                ((ComplexNodeExpression)input).appendLabel(context, varName + (i + 1));
                continue;
            }
            context.indent();
            context.append("BIND (");
            context.append(input.toString());
            context.append(" AS ?");
            context.append(varName + (i + 1));
            context.append(") .\n");
        }
        context.indent();
        context.append("FILTER (bound(?");
        context.append(varName);
        context.append("1) ");
        for (i = 1; i < this.inputs.size(); ++i) {
            context.append(" && ?");
            context.append(varName + (i + 1));
            context.append("=?");
            context.append(varName + "1");
        }
        context.append(") .\n");
        context.indent();
        context.append("BIND (?");
        context.append(varName);
        context.append("1 AS ?");
        context.append(targetVarName);
        context.append(") .\n");
    }

    @Override
    public List<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        Iterator<NodeExpression> it = this.inputs.iterator();
        HashSet<RDFNode> results = new HashSet<RDFNode>(it.next().eval(focusNode, context));
        while (it.hasNext()) {
            results.retainAll(it.next().eval(focusNode, context));
        }
        return new ArrayList<RDFNode>(results);
    }
}

