/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.SPINThreadFunctionRegistry;
import org.topbraid.spin.arq.SPINThreadFunctions;
import org.topbraid.spin.util.JenaUtil;

public class JSTestCaseType
implements TestCaseType {
    @Override
    public Collection<TestCase> getTestCases(Model model, Resource graph) {
        LinkedList<TestCase> results = new LinkedList<TestCase>();
        for (Resource resource : JenaUtil.getAllInstances(model.getResource(DASH.JSTestCase.getURI()))) {
            results.add(new JSTestCase(graph, resource));
        }
        return results;
    }

    private static class JSTestCase
    extends TestCase {
        JSTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(Model results) {
            block32: {
                Resource testCase = this.getResource();
                FunctionRegistry oldFR = FunctionRegistry.get();
                SPINThreadFunctionRegistry threadFR = new SPINThreadFunctionRegistry(oldFR);
                FunctionRegistry.set((Context)ARQ.getContext(), (FunctionRegistry)threadFR);
                SPINThreadFunctions old = SPINThreadFunctionRegistry.register(testCase.getModel());
                Statement expectedResultS = testCase.getProperty(DASH.expectedResult);
                String queryString = "SELECT (<" + this.getResource() + ">() AS ?result) WHERE {}";
                Query query = ARQFactory.get().createQuery(testCase.getModel(), queryString);
                try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, testCase.getModel());){
                    ResultSet rs = qexec.execSelect();
                    if (!rs.hasNext()) {
                        if (expectedResultS != null) {
                            this.createFailure(results, "Expression returned no result, but expected: " + expectedResultS.getObject());
                            return;
                        }
                        break block32;
                    }
                    RDFNode result = rs.next().get("result");
                    if (expectedResultS == null) {
                        if (result != null) {
                            this.createFailure(results, "Expression returned a result, but none expected: " + result);
                            return;
                        }
                    } else if (!expectedResultS.getObject().equals(result)) {
                        this.createFailure(results, "Mismatching result. Expected: " + expectedResultS.getObject() + ". Found: " + result);
                        return;
                    }
                }
                finally {
                    SPINThreadFunctionRegistry.unregister(old);
                    FunctionRegistry.set((Context)ARQ.getContext(), (FunctionRegistry)oldFR);
                }
            }
            this.createResult(results, DASH.SuccessTestCaseResult);
        }
    }
}

