/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.system;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.system.SPINModuleRegistry;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class SPINImports {
    private Set<String> registeredURIs = new HashSet<String>();
    public static SPINImports singleton = new SPINImports();

    public static SPINImports get() {
        return singleton;
    }

    protected Graph getImportedGraph(String uri) throws IOException {
        Model model = OntDocumentManager.getInstance().getModel(uri);
        if (model == null) {
            Model baseModel = JenaUtil.createDefaultModel();
            baseModel.read(uri);
            model = JenaUtil.createOntologyModel(OntModelSpec.OWL_MEM, baseModel);
            OntDocumentManager.getInstance().addModel(uri, model);
        }
        return model.getGraph();
    }

    public Model getImportsModel(Model model) throws IOException {
        HashSet<String> uris = new HashSet<String>();
        StmtIterator it = model.listStatements(null, SPIN.imports, (RDFNode)null);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getObject().isURIResource()) continue;
            uris.add(s.getResource().getURI());
        }
        if (uris.isEmpty()) {
            return model;
        }
        Graph baseGraph = model.getGraph();
        MultiUnion union = JenaUtil.createMultiUnion();
        union.addGraph(baseGraph);
        union.setBaseGraph(baseGraph);
        boolean needsRegistration = false;
        for (String uri : uris) {
            Graph graph = this.getImportedGraph(uri);
            if (graph == null) continue;
            union.addGraph(graph);
            if (this.registeredURIs.contains(uri)) continue;
            this.registeredURIs.add(uri);
            needsRegistration = true;
        }
        this.ensureImported(union, "http://spinrdf.org/sp", SP.getModel());
        this.ensureImported(union, "http://spinrdf.org/spl", SPL.getModel());
        this.ensureImported(union, "http://spinrdf.org/spin", SPIN.getModel());
        Model unionModel = ModelFactory.createModelForGraph((Graph)union);
        if (needsRegistration) {
            SPINModuleRegistry.get().registerAll(unionModel, null);
        }
        return unionModel;
    }

    private void ensureImported(MultiUnion union, String baseURI, Model model) {
        if (!union.contains(Triple.create((Node)NodeFactory.createURI((String)baseURI), (Node)RDF.type.asNode(), (Node)OWL.Ontology.asNode()))) {
            union.addGraph(model.getGraph());
        }
    }

    public static void set(SPINImports value) {
        singleton = value;
    }
}

