/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.io.InputStream;
import org.apache.jena.rdf.model.Model;
import org.topbraid.shacl.arq.SHACLFunctions;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SystemTriples;

public class SHACLSystemModel {
    private static Model shaclModel;

    public static Model getSHACLModel() {
        if (shaclModel == null) {
            shaclModel = JenaUtil.createDefaultModel();
            InputStream shaclTTL = SHACLSystemModel.class.getResourceAsStream("/etc/shacl.ttl");
            shaclModel.read(shaclTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
            InputStream dashTTL = SHACLSystemModel.class.getResourceAsStream("/etc/dash.ttl");
            shaclModel.read(dashTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
            InputStream toshTTL = SHACLSystemModel.class.getResourceAsStream("/etc/tosh.ttl");
            shaclModel.read(toshTTL, "http://www.w3.org/ns/shacl#", "TURTLE");
            shaclModel.add(SystemTriples.getVocabularyModel());
            SHACLFunctions.registerFunctions(shaclModel);
        }
        return shaclModel;
    }
}

