/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.spr;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.spr.TableEngine;
import org.topbraid.spin.spr.spra.ATableEngine;
import org.topbraid.spin.vocabulary.SPRA;

public class TableEngines {
    private static TableEngines singleton = new TableEngines();
    private TableEngine defaultTableEngine = new ATableEngine();
    private Map<Resource, TableEngine> map = new HashMap<Resource, TableEngine>();

    public static TableEngines get() {
        return singleton;
    }

    public static void set(TableEngines value) {
        singleton = value;
    }

    public TableEngines() {
        this.map.put(SPRA.Table, this.defaultTableEngine);
    }

    public TableEngine getDefaultTableEngine() {
        return this.defaultTableEngine;
    }

    public TableEngine getForType(Resource type) {
        return this.map.get(type);
    }

    public void register(Resource type, TableEngine tableEngine) {
        this.map.put(type, tableEngine);
    }
}

