/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.writer.WriterStreamRDFBase;
import org.apache.jena.sparql.core.Quad;

abstract class WriterStreamRDFBatched
extends WriterStreamRDFBase {
    private Node currentSubject;
    private Node currentGraph;
    private List<Triple> batchTriples;
    private List<Quad> batchQuads;

    public WriterStreamRDFBatched(OutputStream output) {
        super(output);
    }

    public WriterStreamRDFBatched(Writer output) {
        super(output);
    }

    public WriterStreamRDFBatched(IndentedWriter output) {
        super(output);
    }

    @Override
    protected final void startData() {
        this.reset();
    }

    @Override
    protected final void endData() {
        this.flush();
    }

    private void flush() {
        this.finishBatchTriples(this.currentSubject);
        this.finishBatchQuad(this.currentGraph, this.currentSubject);
        this.finalizeRun();
    }

    @Override
    protected final void reset() {
        this.currentSubject = null;
        this.currentGraph = null;
        this.batchTriples = null;
        this.batchQuads = null;
    }

    @Override
    protected final void print(Quad quad) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        if (!Objects.equals(g, this.currentGraph) || !Objects.equals(s, this.currentSubject)) {
            if (this.currentSubject != null) {
                if (this.currentGraph == null) {
                    this.finishBatchTriples(this.currentSubject);
                } else {
                    this.finishBatchQuad(this.currentGraph, this.currentSubject);
                }
            }
            this.startBatchQuad(g, s);
            this.currentGraph = g;
            this.currentSubject = s;
        }
        this.processQuad(quad);
    }

    @Override
    protected final void print(Triple triple) {
        Node s = triple.getSubject();
        if (!Objects.equals(s, this.currentSubject)) {
            if (this.currentSubject != null) {
                this.finishBatchTriples(this.currentSubject);
            }
            this.startBatchTriple(s);
            this.currentGraph = null;
            this.currentSubject = s;
        }
        this.processTriple(triple);
    }

    private void startBatchTriple(Node subject) {
        this.batchTriples = new ArrayList<Triple>();
    }

    private void processTriple(Triple triple) {
        this.batchTriples.add(triple);
    }

    private void finishBatchTriples(Node subject) {
        if (this.batchTriples != null && this.batchTriples.size() > 0) {
            this.printBatchTriples(this.currentSubject, this.batchTriples);
            this.batchTriples.clear();
        }
    }

    private void startBatchQuad(Node graph, Node subject) {
        this.batchQuads = new ArrayList<Quad>();
    }

    private void processQuad(Quad Quad2) {
        this.batchQuads.add(Quad2);
    }

    private void finishBatchQuad(Node graph, Node subject) {
        if (this.batchQuads != null && this.batchQuads.size() > 0) {
            this.printBatchQuads(this.currentGraph, this.currentSubject, this.batchQuads);
            this.batchQuads.clear();
        }
    }

    protected abstract void printBatchQuads(Node var1, Node var2, List<Quad> var3);

    protected abstract void printBatchTriples(Node var1, List<Triple> var2);

    protected abstract void finalizeRun();
}

