/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.core.AMFCompiler$;
import amf.core.Root;
import amf.core.exception.CyclicReferenceException;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.ExternalFragment$;
import amf.core.model.domain.ExternalDomainElement;
import amf.core.model.domain.ExternalDomainElement$;
import amf.core.model.domain.idCounter$;
import amf.core.parser.AbstractReferenceCollector;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ParsedReference;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.parser.Reference;
import amf.core.parser.ReferenceKind;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Content;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.Platform;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u001d\u00111\"Q'G\u0007>l\u0007/\u001b7fe*\u00111\u0001B\u0001\u0005G>\u0014XMC\u0001\u0006\u0003\r\tWNZ\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u0005\u0019QO\u001d7\u0016\u0003E\u0001\"AE\r\u000f\u0005M9\u0002C\u0001\u000b\u000b\u001b\u0005)\"B\u0001\f\u0007\u0003\u0019a$o\\8u}%\u0011\u0001DC\u0001\u0007!J,G-\u001a4\n\u0005iY\"AB*ue&twM\u0003\u0002\u0019\u0015!AQ\u0004\u0001B\u0001B\u0003%\u0011#\u0001\u0003ve2\u0004\u0003\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\rI,Wn\u001c;f+\u0005\t\u0003C\u0001\u0012%\u001b\u0005\u0019#BA\u0010\u0003\u0013\t)3E\u0001\u0005QY\u0006$hm\u001c:n\u0011!9\u0003A!A!\u0002\u0013\t\u0013a\u0002:f[>$X\r\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005!!-Y:f+\u0005Y\u0003cA\u0005-]%\u0011QF\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\tz\u0013B\u0001\u0019$\u0005\u001d\u0019uN\u001c;fqRD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0006E\u0006\u001cX\r\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005IQ.\u001a3jCRK\b/Z\u000b\u0002mA\u0019\u0011\u0002L\t\t\u0011a\u0002!\u0011!Q\u0001\nY\n!\"\\3eS\u0006$\u0016\u0010]3!\u0011!Q\u0004A!b\u0001\n\u0003\u0001\u0012A\u0002<f]\u0012|'\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003\u0012\u0003\u001d1XM\u001c3pe\u0002B\u0001B\u0010\u0001\u0003\u0006\u0004%\taP\u0001\u000ee\u00164WM]3oG\u0016\\\u0015N\u001c3\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0002\u0002\rA\f'o]3s\u0013\t)%IA\u0007SK\u001a,'/\u001a8dK.Kg\u000e\u001a\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0001\u0006q!/\u001a4fe\u0016t7-Z&j]\u0012\u0004\u0003\u0002C%\u0001\u0005\u000b\u0007I\u0011\u0002&\u0002\u000b\r\f7\r[3\u0016\u0003-\u0003\"A\t'\n\u00055\u001b#!B\"bG\",\u0007\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\r\r\f7\r[3!\u0011!\t\u0006A!b\u0001\n\u0013\u0011\u0016a\u00032bg\u0016\u001cuN\u001c;fqR,\u0012a\u0015\t\u0004\u00131\"\u0006CA!V\u0013\t1&IA\u0007QCJ\u001cXM]\"p]R,\u0007\u0010\u001e\u0005\t1\u0002\u0011\t\u0011)A\u0005'\u0006a!-Y:f\u0007>tG/\u001a=uA!)!\f\u0001C\u00017\u00061A(\u001b8jiz\"\u0012\u0002\u00180`A\u0006\u00147\rZ3\u0011\u0005u\u0003Q\"\u0001\u0002\t\u000b=I\u0006\u0019A\t\t\u000b}I\u0006\u0019A\u0011\t\u000b%J\u0006\u0019A\u0016\t\u000bQJ\u0006\u0019\u0001\u001c\t\u000biJ\u0006\u0019A\t\t\u000byJ\u0006\u0019\u0001!\t\u000b%K\u0006\u0019A&\t\u000fEK\u0006\u0013!a\u0001'\"Aq\r\u0001EC\u0002\u0013%\u0001.A\u0004d_:$X\r\u001f;\u0016\u00039B\u0001B\u001b\u0001\t\u0006\u0004%I\u0001E\u0001\tY>\u001c\u0017\r^5p]\"9A\u000e\u0001b\u0001\n\u0013i\u0017A\u0003:fM\u0016\u0014XM\\2fgV\ta\u000eE\u0002piZl\u0011\u0001\u001d\u0006\u0003cJ\fq!\\;uC\ndWM\u0003\u0002t\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0004(A\u0003'jgR\u0014UO\u001a4feB\u0019qO\u001f?\u000e\u0003aT!!\u001f\u0006\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002|q\n1a)\u001e;ve\u0016\u0004\"!Q?\n\u0005y\u0014%a\u0004)beN,GMU3gKJ,gnY3\t\u000f\u0005\u0005\u0001\u0001)A\u0005]\u0006Y!/\u001a4fe\u0016t7-Z:!\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9!A\u0002dib,\u0012\u0001\u0016\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003U\u0003\u0011\u0019G\u000f\u001f\u0011\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0005)!-^5mIR\u0011\u00111\u0003\t\u0005oj\f)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0011\u0011|7-^7f]RT1!a\b\u0003\u0003\u0015iw\u000eZ3m\u0013\u0011\t\u0019#!\u0007\u0003\u0011\t\u000b7/Z+oSRDq!a\n\u0001\t\u0013\t\t\"A\u0004d_6\u0004\u0018\u000e\\3\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005Y\u0001/\u0019:tKNKh\u000e^1y)\u0011\ty#!\u0014\u0011\u0011\u0005E\u00121HA!\u0003\u000frA!a\r\u000289\u0019A#!\u000e\n\u0003-I1!!\u000f\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0002@\t1Q)\u001b;iKJT1!!\u000f\u000b!\r\u0011\u00131I\u0005\u0004\u0003\u000b\u001a#aB\"p]R,g\u000e\u001e\t\u0004;\u0006%\u0013bAA&\u0005\t!!k\\8u\u0011!\ty%!\u000bA\u0002\u0005\u0005\u0013aB2p]R,g\u000e\u001e\u0005\b\u0003'\u0002A\u0011AA+\u0003U\u0001\u0018M]:f\u000bb$XM\u001d8bY\u001a\u0013\u0018mZ7f]R$B!a\u0005\u0002X!A\u0011qJA)\u0001\u0004\t\t\u0005C\u0004\u0002\\\u0001!I!!\u0018\u0002\u0017A\f'o]3E_6\f\u0017N\u001c\u000b\u0005\u0003'\ty\u0006\u0003\u0005\u0002b\u0005e\u0003\u0019AA\u0018\u0003\u0019\u0001\u0018M]:fI\"9\u00111\f\u0001\u0005\n\u0005\u0015D\u0003BA\n\u0003OB\u0001\"a\u0007\u0002d\u0001\u0007\u0011q\t\u0005\b\u0003W\u0002A\u0011BA7\u0003=\u0001\u0018M]:f%\u00164WM]3oG\u0016\u001cHCBA8\u0003c\n)\b\u0005\u0003xu\u0006\u001d\u0003\u0002CA:\u0003S\u0002\r!a\u0012\u0002\tI|w\u000e\u001e\u0005\t\u0003o\nI\u00071\u0001\u0002z\u0005aAm\\7bS:\u0004F.^4j]B!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000\t\tq\u0001\u001d7vO&t7/\u0003\u0003\u0002\u0004\u0006u$!E!N\r\u0012{7-^7f]R\u0004F.^4j]\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015a\u0002:fg>dg/\u001a\u000b\u0003\u0003\u0017\u0003Ba\u001e>\u0002B!9\u00111\u000f\u0001\u0005\u0002\u0005=ECAA8\u000f\u001d\t\u0019J\u0001E\u0001\u0003+\u000b1\"Q'G\u0007>l\u0007/\u001b7feB\u0019Q,a&\u0007\r\u0005\u0011\u0001\u0012AAM'\r\t9\n\u0003\u0005\b5\u0006]E\u0011AAO)\t\t)\n\u0003\u0005\u0002\"\u0006]E\u0011AAR\u0003\u0011Ig.\u001b;\u0015\u0005\u0005\u0015\u0006cA\u0005\u0002(&\u0019\u0011\u0011\u0016\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003[\u000b9*%A\u0005\u0002\u0005=\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u00022*\u001a1+a-,\u0005\u0005U\u0006\u0003BA\\\u0003\u0003l!!!/\u000b\t\u0005m\u0016QX\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a0\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\fILA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class AMFCompiler {
    private Context context;
    private String location;
    private final String url;
    private final Platform remote;
    private final Option<Context> base;
    private final Option<String> mediaType;
    private final String vendor;
    private final ReferenceKind referenceKind;
    private final Cache cache;
    private final Option<ParserContext> baseContext;
    private final ListBuffer<Future<ParsedReference>> references;
    private final ParserContext ctx;
    private volatile byte bitmap$0;

    public static Option<ParserContext> $lessinit$greater$default$8() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$8();
    }

    public static void init() {
        AMFCompiler$.MODULE$.init();
    }

    public String url() {
        return this.url;
    }

    public Platform remote() {
        return this.remote;
    }

    public Option<Context> base() {
        return this.base;
    }

    public Option<String> mediaType() {
        return this.mediaType;
    }

    public String vendor() {
        return this.vendor;
    }

    public ReferenceKind referenceKind() {
        return this.referenceKind;
    }

    private Cache cache() {
        return this.cache;
    }

    private Option<ParserContext> baseContext() {
        return this.baseContext;
    }

    private Context context$lzycompute() {
        AMFCompiler aMFCompiler = this;
        synchronized (aMFCompiler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.context = (Context)this.base().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.update(this.url())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Context$.MODULE$.apply(this.remote(), this.url()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.context;
    }

    private Context context() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.context$lzycompute() : this.context;
    }

    private String location$lzycompute() {
        AMFCompiler aMFCompiler = this;
        synchronized (aMFCompiler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.location = this.context().current();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.location;
    }

    private String location() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.location$lzycompute() : this.location;
    }

    private ListBuffer<Future<ParsedReference>> references() {
        return this.references;
    }

    private ParserContext ctx() {
        return this.ctx;
    }

    public Future<BaseUnit> build() {
        idCounter$.MODULE$.reset();
        return this.context().hasCycles() ? Future$.MODULE$.failed((Throwable)new CyclicReferenceException(this.context().history())) : this.cache().getOrUpdate(this.location(), (Function0<Future<BaseUnit>>)(Function0 & Serializable & scala.Serializable)() -> this.compile());
    }

    private Future<BaseUnit> compile() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)content -> this.parseSyntax((Content)content), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)parsed -> this.parseDomain((Either<Content, Root>)parsed), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Either<Content, Root> parseSyntax(Content content) {
        Left left;
        Option parsed = content.mime().orElse((Function0 & Serializable & scala.Serializable)() -> this.mediaType()).flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parse((String)mime, content.stream())));
        Option option = parsed;
        if (option instanceof Some) {
            Some some = (Some)option;
            ParsedDocument document = (ParsedDocument)some.value();
            left = package$.MODULE$.Right().apply((Object)new Root(document, content.url(), (String)content.mime().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)this.mediaType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (Seq<ParsedReference>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.referenceKind(), this.vendor(), content.stream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)content);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Future<BaseUnit> parseExternalFragment(Content content) {
        ExternalDomainElement result = ExternalDomainElement$.MODULE$.apply().withRaw(content.stream().toString());
        content.mime().foreach((Function1 & Serializable & scala.Serializable)mime -> result.withMediaType((String)mime));
        return Future$.MODULE$.successful((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withId(content.url())).withEncodes(result));
    }

    private Future<BaseUnit> parseDomain(Either<Content, Root> parsed) {
        Future<BaseUnit> future;
        Either<Content, Root> either = parsed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Content content = (Content)left.value();
            future = this.parseExternalFragment(content);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Root document = (Root)right.value();
            future = this.parseDomain(document);
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    private Future<BaseUnit> parseDomain(Root document) {
        Future future;
        Some domainPluginOption;
        Some some;
        Option option = AMFPluginsRegistry$.MODULE$.documentPluginForVendor(this.vendor()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.canParse(document)));
        if (option instanceof Some) {
            Some some2 = (Some)option;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some2.value();
            some = new Some((Object)domainPlugin);
        } else if (None$.MODULE$.equals(option)) {
            some = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(document.mediatype()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.canParse(document)));
        } else {
            throw new MatchError((Object)option);
        }
        Some some3 = domainPluginOption = some;
        if (some3 instanceof Some) {
            Some some4 = some3;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some4.value();
            future = this.parseReferences(document, domainPlugin).map((Function1 & Serializable & scala.Serializable)documentWithReferences -> {
                BaseUnit baseUnit;
                Option<BaseUnit> option = domainPlugin.parse((Root)documentWithReferences, this.ctx(), this.remote());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BaseUnit baseUnit2 = (BaseUnit)some.value();
                    baseUnit = baseUnit2.withRaw(document.raw());
                } else if (None$.MODULE$.equals(option)) {
                    ExternalFragment fragment = (ExternalFragment)ExternalFragment$.MODULE$.apply().withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
                    baseUnit = fragment;
                } else {
                    throw new MatchError(option);
                }
                return baseUnit;
            }, ExecutionContext.Implicits$.MODULE$.global());
        } else if (None$.MODULE$.equals(some3)) {
            ExternalFragment fragment = (ExternalFragment)((EncodesModel)ExternalFragment$.MODULE$.apply().withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
            future = Future$.MODULE$.successful((Object)fragment);
        } else {
            throw new MatchError((Object)some3);
        }
        return future;
    }

    private Future<Root> parseReferences(Root root, AMFDocumentPlugin domainPlugin) {
        AbstractReferenceCollector referenceCollector = domainPlugin.referenceCollector();
        Seq<Reference> refs = referenceCollector.traverse(root.parsed(), this.ctx());
        ((IterableLike)refs.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isRemote()))).foreach((Function1 & Serializable & scala.Serializable)link -> this.references().$plus$eq((Object)link.resolve(this.remote(), (Option<Context>)new Some((Object)this.context()), (Option<String>)None$.MODULE$, domainPlugin.ID(), this.cache(), this.ctx()).map((Function1 & Serializable & scala.Serializable)x$6 -> new ParsedReference((BaseUnit)x$6, (Reference)link), ExecutionContext.Implicits$.MODULE$.global())));
        return Future$.MODULE$.sequence(this.references(), ListBuffer$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)rs -> {
            ListBuffer x$8 = rs;
            String x$9 = domainPlugin.ID();
            ParsedDocument x$10 = root.copy$default$1();
            String x$11 = root.copy$default$2();
            String x$12 = root.copy$default$3();
            ReferenceKind x$13 = root.copy$default$5();
            String x$14 = root.copy$default$7();
            return root.copy(x$10, x$11, x$12, (Seq<ParsedReference>)x$8, x$13, x$9, x$14);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Content> resolve() {
        return this.remote().resolve(this.location(), this.base());
    }

    public Future<Root> root() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)content -> this.parseSyntax((Content)content), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Root document;
            Either either = x0$1;
            if (either instanceof Right && (document = (Root)(right = (Right)either).value()) != null) {
                Future future;
                Root root = document;
                Option option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(root.mediatype()).find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.canParse(root)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                    future = this.parseReferences(root, domainPlugin);
                    return future;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> root, ExecutionContext.Implicits$.MODULE$.global());
                }
                return future;
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Content content = (Content)left.value();
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse document with mime type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{content.mime().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")})));
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public AMFCompiler(String url, Platform remote, Option<Context> base, Option<String> mediaType, String vendor, ReferenceKind referenceKind, Cache cache, Option<ParserContext> baseContext) {
        this.url = url;
        this.remote = remote;
        this.base = base;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.referenceKind = referenceKind;
        this.cache = cache;
        this.baseContext = baseContext;
        this.references = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.ctx = (ParserContext)((Object)baseContext.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ParserContext(this.url(), (Seq<ParsedReference>)((Seq)Seq$.MODULE$.empty()), ParserContext$.MODULE$.apply$default$3())));
    }
}

