/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.js.model;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapStd;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.topbraid.shacl.js.model.JSBlankNode;
import org.topbraid.shacl.js.model.JSLiteral;
import org.topbraid.shacl.js.model.JSNamedNode;
import org.topbraid.shacl.js.model.JSTerm;

public class TermFactory {
    private PrefixMap pm = new PrefixMapStd();

    public JSBlankNode blankNode() {
        return this.blankNode(null);
    }

    public JSBlankNode blankNode(String value) {
        Node node = value == null ? NodeFactory.createBlankNode() : NodeFactory.createBlankNode((String)value);
        return new JSBlankNode(node);
    }

    public JSLiteral literal(String value, Object langOrDatatype) {
        if (langOrDatatype instanceof JSNamedNode) {
            return new JSLiteral(NodeFactory.createLiteral((String)value, (RDFDatatype)TypeMapper.getInstance().getTypeByName(((JSNamedNode)langOrDatatype).getValue())));
        }
        if (langOrDatatype instanceof String) {
            return new JSLiteral(NodeFactory.createLiteral((String)value, (String)((String)langOrDatatype)));
        }
        throw new IllegalArgumentException("Invalid type of langOrDatatype argument");
    }

    public JSNamedNode namedNode(String value) {
        Node node = NodeFactory.createURI((String)value);
        return new JSNamedNode(node);
    }

    public void registerNamespace(String prefix, String namespace) {
        this.pm.add(prefix, namespace);
    }

    public JSTerm term(String str) {
        Node n = NodeFactoryExtra.parseNode((String)str, (PrefixMap)this.pm);
        if (n.isURI()) {
            return new JSNamedNode(n);
        }
        if (n.isLiteral()) {
            return new JSLiteral(n);
        }
        if (n.isBlank()) {
            return new JSBlankNode(n);
        }
        throw new IllegalArgumentException("Unexpected node type for " + n);
    }
}

