/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.client.cache.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarCacheResource
implements Resource {
    private static final long serialVersionUID = -7101296464577357444L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final URLConnection connection;

    public JarCacheResource(URL classpath) throws IOException {
        this.connection = classpath.openConnection();
    }

    public long length() {
        return this.connection.getContentLength();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public void dispose() {
        try {
            this.connection.getInputStream().close();
        }
        catch (IOException e) {
            this.log.error("Can't close JarCacheResource input stream", (Throwable)e);
        }
    }
}

