/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2ProtocolUtils;
import io.undertow.protocols.http2.Http2PushBackParser;
import java.nio.ByteBuffer;

public class Http2GoAwayParser
extends Http2PushBackParser {
    private int statusCode;
    private int lastGoodStreamId;

    public Http2GoAwayParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser headerParser) {
        if (resource.remaining() < 8) {
            return;
        }
        this.lastGoodStreamId = Http2ProtocolUtils.readInt(resource);
        this.statusCode = Http2ProtocolUtils.readInt(resource);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getLastGoodStreamId() {
        return this.lastGoodStreamId;
    }
}

