/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.persistent;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public interface PersistentMap<K, V, SelfType extends PersistentMap<K, V, SelfType>> {
    default public Optional<V> get(K key) {
        return this.entryStream().filter(e -> e.getKey().equals(key)).map(Map.Entry::getValue).findFirst();
    }

    public SelfType plus(K var1, V var2);

    public SelfType minus(K var1);

    default public boolean containsKey(K key) {
        return this.get(key).isPresent();
    }

    public Stream<Map.Entry<K, V>> entryStream();

    default public <R> Stream<R> flatten(BiFunction<K, V, Stream<R>> f) {
        return this.entryStream().flatMap(e -> (Stream)f.apply(e.getKey(), e.getValue()));
    }
}

