/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Map;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.spin.model.Command;

public abstract class CommandWrapper {
    private String label;
    private Resource source;
    private Statement statement;
    private Map<String, RDFNode> templateBinding;
    private String text;
    private boolean thisDeep;
    private boolean thisUnbound;

    public CommandWrapper(Resource source, String text, String label, Statement statement, boolean thisUnbound, boolean thisDeep) {
        this.label = label;
        this.statement = statement;
        this.source = source;
        this.text = text;
        this.thisDeep = thisDeep;
        this.thisUnbound = thisUnbound;
    }

    public Map<String, RDFNode> getTemplateBinding() {
        return this.templateBinding;
    }

    public String getLabel() {
        return this.label;
    }

    public abstract Command getSPINCommand();

    public Statement getStatement() {
        return this.statement;
    }

    public Resource getSource() {
        return this.source;
    }

    public String getText() {
        return this.text;
    }

    public boolean isThisDeep() {
        return this.thisDeep;
    }

    public boolean isThisUnbound() {
        return this.thisUnbound;
    }

    public void setTemplateBinding(Map<String, RDFNode> value) {
        this.templateBinding = value;
    }
}

