/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class SPLUtil {
    private static final Property ARG_PROPERTY = ResourceFactory.createProperty((String)"http://spinrdf.org/arg#property");

    private static void addDefaultValuesForType(Resource cls, Map<Property, RDFNode> results, Set<Resource> reached) {
        reached.add(cls);
        StmtIterator it = cls.listProperties(SPIN.rule);
        while (it.hasNext()) {
            Statement v;
            Property predicate;
            Statement predicateS;
            Resource templateCall;
            Statement s = it.nextStatement();
            if (!s.getObject().isResource() || !(templateCall = s.getResource()).hasProperty(RDF.type, (RDFNode)SPL.InferDefaultValue) || (predicateS = templateCall.getProperty(SPL.predicate)) == null || !predicateS.getObject().isURIResource() || results.containsKey(predicate = cls.getModel().getProperty(predicateS.getResource().getURI())) || (v = templateCall.getProperty(SPL.defaultValue)) == null) continue;
            results.put(predicate, v.getObject());
        }
        for (Resource superClass : JenaUtil.getSuperClasses(cls)) {
            if (reached.contains(superClass)) continue;
            SPLUtil.addDefaultValuesForType(superClass, results, reached);
        }
    }

    public static Argument getArgument(Resource subject, Property predicate) {
        HashSet<Resource> reached = new HashSet<Resource>();
        for (Resource type : JenaUtil.getAllTypes(subject)) {
            Argument arg = SPLUtil.getArgumentHelper(type, predicate, reached);
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    private static Argument getArgumentHelper(Resource type, Property predicate, Set<Resource> reached) {
        if (reached.contains(type)) {
            return null;
        }
        reached.add(type);
        StmtIterator it = type.listProperties(SPIN.constraint);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isAnon() || !s.getResource().hasProperty(SPL.predicate, (RDFNode)predicate) || !s.getResource().hasProperty(RDF.type, (RDFNode)SPL.Argument)) continue;
            it.close();
            return (Argument)s.getResource().as(Argument.class);
        }
        for (Statement ss : type.listProperties(RDFS.subClassOf).toList()) {
            Argument arg;
            if (!ss.getObject().isResource() || (arg = SPLUtil.getArgumentHelper(ss.getResource(), predicate, reached)) == null) continue;
            return arg;
        }
        return null;
    }

    private static RDFNode getDefaultValueForType(Resource cls, Property predicate, Set<Resource> reached) {
        reached.add(cls);
        StmtIterator it = cls.listProperties(SPIN.rule);
        while (it.hasNext()) {
            Statement v;
            Resource templateCall;
            Statement s = it.nextStatement();
            if (!s.getObject().isResource() || !(templateCall = s.getResource()).hasProperty(RDF.type, (RDFNode)SPL.InferDefaultValue) || !templateCall.hasProperty(SPL.predicate, (RDFNode)predicate) || (v = templateCall.getProperty(SPL.defaultValue)) == null) continue;
            it.close();
            return v.getObject();
        }
        for (Resource superClass : JenaUtil.getSuperClasses(cls)) {
            RDFNode value;
            if (reached.contains(superClass) || (value = SPLUtil.getDefaultValueForType(superClass, predicate, reached)) == null) continue;
            return value;
        }
        return null;
    }

    public static Map<Property, RDFNode> getDefaultValues(Resource subject) {
        HashMap<Property, RDFNode> results = new HashMap<Property, RDFNode>();
        HashSet<Resource> reached = new HashSet<Resource>();
        for (Resource type : JenaUtil.getTypes(subject)) {
            SPLUtil.addDefaultValuesForType(type, results, reached);
        }
        return results;
    }

    public static RDFNode getObject(Resource subject, Property predicate) {
        return SPLUtil.getObject(subject, predicate, false);
    }

    public static RDFNode getObject(Resource subject, Property predicate, boolean includeSubProperties) {
        Statement s = subject.getProperty(predicate);
        if (s != null) {
            return s.getObject();
        }
        HashSet<Resource> reached = new HashSet<Resource>();
        for (Resource type : JenaUtil.getTypes(subject)) {
            RDFNode object = SPLUtil.getDefaultValueForType(type, predicate, reached);
            if (object == null) continue;
            return object;
        }
        if (includeSubProperties) {
            for (Resource subProperty : JenaUtil.getAllSubProperties(predicate)) {
                Property pred = (Property)subProperty.as(Property.class);
                RDFNode value = SPLUtil.getObject(subject, pred, false);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static Property getPrimaryKeyProperty(Resource cls) {
        return SPLUtil.getPrimaryKeyPropertyHelper(cls, new HashSet<Resource>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Property getPrimaryKeyPropertyHelper(Resource cls, Set<Resource> reached) {
        try (StmtIterator it = cls.listProperties(SPIN.constraint);){
            while (it.hasNext()) {
                Resource prop;
                Resource constraint;
                RDFNode object = ((Statement)it.next()).getObject();
                if (!object.isResource() || !(constraint = (Resource)object).hasProperty(RDF.type, (RDFNode)SPL.PrimaryKeyPropertyConstraint) || (prop = JenaUtil.getResourceProperty(constraint, ARG_PROPERTY)) == null || !prop.isURIResource()) continue;
                Property property = JenaUtil.asProperty(prop);
                return property;
            }
        }
        reached.add(cls);
        for (Resource superClass : JenaUtil.getSuperClasses(cls)) {
            Property p;
            if (reached.contains(superClass) || (p = SPLUtil.getPrimaryKeyPropertyHelper(superClass, reached)) == null) continue;
            return p;
        }
        return null;
    }

    public static String getPrimaryKeyURIStart(Resource cls) {
        Node result = JenaUtil.invokeFunction1(SPL.primaryKeyURIStart, cls.asNode(), ARQFactory.get().getDataset(cls.getModel()));
        if (result != null) {
            return result.getLiteralLexicalForm();
        }
        return null;
    }

    public static boolean hasPrimaryKey(Resource cls) {
        return JenaUtil.invokeFunction1(SPL.primaryKeyProperty, cls.asNode(), ARQFactory.get().getDataset(cls.getModel())) != null;
    }

    public static boolean isArgument(Resource resource) {
        return JenaUtil.hasIndirectType(resource, SPL.Argument.inModel(resource.getModel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArgumentPredicate(Resource subject, Property predicate) {
        StmtIterator args = null;
        StmtIterator classes = null;
        JenaUtil.setGraphReadOptimization(true);
        try {
            if (SP.exists(subject.getModel())) {
                Model model = predicate.getModel();
                args = model.listStatements(null, SPL.predicate, (RDFNode)predicate);
                while (args.hasNext()) {
                    Resource arg = ((Statement)args.next()).getSubject();
                    if (!arg.hasProperty(RDF.type, (RDFNode)SPL.Argument)) continue;
                    classes = model.listStatements(null, SPIN.constraint, (RDFNode)arg);
                    while (classes.hasNext()) {
                        Resource cls = ((Statement)classes.next()).getSubject();
                        if (!JenaUtil.hasIndirectType(subject, cls)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (classes != null) {
                classes.close();
            }
            if (args != null) {
                args.close();
            }
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    public static boolean isOnProperty(TemplateCall templateCall, Property onProperty) {
        return templateCall.hasProperty(SPL.predicate, (RDFNode)onProperty) && JenaUtil.hasIndirectType(templateCall, SPL.PropertyConstraintTemplates);
    }
}

