/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class QueryEngineFactoryWrapper
implements QueryEngineFactory {
    private static QueryEngineFactory instance = new QueryEngineFactoryWrapper();

    public static QueryEngineFactory get() {
        return instance;
    }

    @Override
    public boolean accept(Query query, DatasetGraph dsg, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return false;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(query, dsg2, context).accept(query, dsg2, context);
    }

    @Override
    public Plan create(Query query, DatasetGraph dsg, Binding inputBinding, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return null;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(query, dsg2, context).create(query, dsg2, inputBinding, context);
    }

    @Override
    public boolean accept(Op op, DatasetGraph dsg, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return false;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(op, dsg2, context).accept(op, dsg2, context);
    }

    @Override
    public Plan create(Op op, DatasetGraph dsg, Binding inputBinding, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return null;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(op, dsg2, context).create(op, dsg2, inputBinding, context);
    }
}

