%dw 2.0
output application/json

import DEBUG from bat::core::Console
import * from dw::http::Client
import normalizeHeaders from dw::http::BodyUtils

fun mockedNow() = if(DEBUG) |2017-10-10T15:10:29| else now()

fun endpoint(): String =
  if(options != null and options.URL != null)
    options.URL default ''
  else
    log('Missing URL option for custom report', '')

fun headers(): { _?: SimpleType } =
  if(options != null and options.HEADERS != null )
    {(options.HEADERS replace "'" with "" splitBy "," map (pair) ->
        using(keyValue = pair splitBy ":") {
            (keyValue[0]): keyValue[1]
        }
    )}
  else {}

---
if (DEBUG or endpoint() == '')
  payload
else
  (request('POST', endpoint(), {
     body: payload,
     headers: normalizeHeaders(headers() default {})
  }) write 'application/json')