/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mulesoft.bat.APIs.Http$;
import com.mulesoft.bat.CLIArguments;
import com.mulesoft.bat.CLILogger$;
import com.mulesoft.bat.CLIXAPI;
import com.mulesoft.bat.ConfigureCLIUrls$;
import com.mulesoft.bat.CredentialsProfile;
import com.mulesoft.bat.Token;
import com.mulesoft.bat.commands.BatPackageCommands$;
import com.mulesoft.bat.commands.BatWorkerCommands$;
import com.mulesoft.bat.lambda.Response;
import com.mulesoft.bat.runner.BatSecret;
import com.mulesoft.bat.types.AccessGrant;
import com.mulesoft.bat.types.AssetDescriptor;
import com.mulesoft.bat.types.CreatedSchedule;
import com.mulesoft.bat.types.CurrentWorker;
import com.mulesoft.bat.types.Dependency;
import com.mulesoft.bat.types.DumbExecution;
import com.mulesoft.bat.types.ExchangeDescriptor;
import com.mulesoft.bat.types.ExchangeDescriptor$;
import com.mulesoft.bat.types.Execution;
import com.mulesoft.bat.types.LoginResponse;
import com.mulesoft.bat.types.LoginResponseOrganization;
import com.mulesoft.bat.types.ProfileResponse;
import com.mulesoft.bat.types.Schedule;
import com.mulesoft.bat.types.Secret;
import com.mulesoft.bat.types.SecretGroup;
import com.mulesoft.bat.types.Target;
import com.mulesoft.bat.types.ZipFile;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Exception$;

public final class CLIXAPI$ {
    public static CLIXAPI$ MODULE$;
    private String host;
    private final String ACCESS_TOKEN;

    static {
        new CLIXAPI$();
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public scala.collection.immutable.Map<String, BatSecret> grant(CLIArguments cfg, String secretGroupName, scala.collection.immutable.Map<String, String> secretNames) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        Predef$.MODULE$.require(profile.environment().isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Environment is missing for profile: ").append(profile.name()).toString());
        String environmentId = (String)profile.environment().get();
        String organizationId = (String)profile.organizationId().get();
        String token = ((Token)profile.token().get()).token();
        String groupsUrl = new StringBuilder(45).append(this.host()).append("/v1/organizations/").append(organizationId).append("/environments/").append(environmentId).append("/secretGroups").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(groupsUrl).toString());
        Response groupsResponse = Http$.MODULE$.get(groupsUrl, token);
        CLILogger$.MODULE$.logDebug(groupsResponse);
        if (groupsResponse.getStatus() != 200) {
            throw new Exception(new StringBuilder(45).append("Error getting secret groups for environment: ").append(environmentId).toString());
        }
        Seq groups = (Seq)Http$.MODULE$.parseResponseJson(groupsResponse, (TypeReference)new TypeReference<Seq<SecretGroup>>(){});
        Option group = groups.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$grant$2(secretGroupName, x$1)));
        Predef$.MODULE$.require(group.isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Cannot find any secret group for name: ").append(secretGroupName).toString());
        String secretsUrl = new StringBuilder(60).append(this.host()).append("/v1/organizations/").append(organizationId).append("/environments/").append(environmentId).append("/secretGroups/").append(((SecretGroup)group.get()).secretGroupId()).append("/sharedSecrets").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(secretsUrl).toString());
        Response secretsResponse = Http$.MODULE$.get(secretsUrl, token);
        CLILogger$.MODULE$.logDebug(secretsResponse);
        if (secretsResponse.getStatus() != 200) {
            throw new Exception(new StringBuilder(33).append("Error getting secrets for group: ").append(secretGroupName).toString());
        }
        Seq secrets = (Seq)Http$.MODULE$.parseResponseJson(secretsResponse, (TypeReference)new TypeReference<Seq<Secret>>(){});
        Seq filteredSecrets = (Seq)secrets.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$grant$4(secretNames, x)));
        Predef$.MODULE$.require(filteredSecrets.nonEmpty() && filteredSecrets.lengthCompare(secretNames.size()) == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Missing secrets for names: ").append(secretNames).toString());
        Seq paths = (Seq)filteredSecrets.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.secretPath(), Seq$.MODULE$.canBuildFrom());
        String grantsUrl = new StringBuilder(53).append(this.host()).append("/v1/organizations/").append(organizationId).append("/environments/").append(environmentId).append("/secretGroups/").append(((SecretGroup)group.get()).secretGroupId()).append("/grants").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("POST ").append(grantsUrl).toString());
        Response grantsResponse = Http$.MODULE$.postJson(grantsUrl, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)paths)})), token);
        CLILogger$.MODULE$.logDebug(grantsResponse);
        if (grantsResponse.getStatus() != 200 && grantsResponse.getStatus() != 201) {
            throw new Exception(new StringBuilder(34).append("Error getting grants for secrets: ").append(paths).toString());
        }
        Seq grants = (Seq)Http$.MODULE$.parseResponseJson(grantsResponse, (TypeReference)new TypeReference<Seq<AccessGrant>>(){});
        Predef$.MODULE$.require(grants.nonEmpty() && filteredSecrets.lengthCompare(secretNames.size()) == 0, (Function0 & Serializable & scala.Serializable)() -> "No grants found");
        return (scala.collection.immutable.Map)secretNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String alias = (String)tuple2._1();
            String name = (String)tuple2._2();
            Secret s = (Secret)secrets.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$grant$10(name, x$4))).get();
            AccessGrant grant = (AccessGrant)grants.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$grant$11(s, x$5))).get();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias), (Object)new BatSecret(name, environmentId, organizationId, ((SecretGroup)group.get()).secretGroupId(), grant.secretId(), grant.accessGrant(), null));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public boolean removeSchedule(CLIArguments cfg, String organizationId, String suite, String scheduleId) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringBuilder(36).append(this.host()).append("/v1/organizations/").append(organizationId).append("/tests/").append(suite).append("/schedules/").append(scheduleId).toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(7).append("DELETE ").append(url).toString());
        Response response = Http$.MODULE$.delete(url, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        return response.getStatus() == 200 || response.getStatus() == 201;
    }

    public boolean updateSchedule(CLIArguments cfg, String organizationId, Schedule schedule, boolean active) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringBuilder(36).append(this.host()).append("/v1/organizations/").append(organizationId).append("/tests/").append(schedule.suite()).append("/schedules/").append(schedule.id()).toString();
        scala.collection.immutable.Map body = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"organizationId"), (Object)organizationId.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), (Object)schedule.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assetId"), (Object)schedule.assetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)schedule.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)schedule.targetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"CRON_EXPRESSION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cron"), (Object)schedule.cron()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)BoxesRunTime.boxToBoolean((boolean)active))}));
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("PUT ").append(url).toString());
        Response response = Http$.MODULE$.putJson(url, (Object)body, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        return response.getStatus() == 200;
    }

    public Option<Schedule> getSchedule(CLIArguments cfg, String organizationId, String scheduleId) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringBuilder(29).append(this.host()).append("/v1/organizations/").append(organizationId).append("/schedules/").append(scheduleId).toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        Response response = Http$.MODULE$.get(url, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200) {
            throw this.handleError(response, new StringBuilder(31).append("Error getting schedule for id: ").append(scheduleId).toString());
        }
        return (Option)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Option<Schedule>>(){});
    }

    public Seq<Schedule> getSchedules(CLIArguments cfg, String organizationId, Option<String> suite) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = suite.isDefined() ? new StringBuilder(35).append(this.host()).append("/v1/organizations/").append(organizationId).append("/tests/").append(suite.get()).append("/schedules").toString() : new StringBuilder(28).append(this.host()).append("/v1/organizations/").append(organizationId).append("/schedules").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        Response response = Http$.MODULE$.get(url, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200) {
            throw this.handleError(response, "Error getting schedules");
        }
        return (Seq)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Seq<Schedule>>(){});
    }

    public Option<String> getSchedules$default$3() {
        return None$.MODULE$;
    }

    public String createDumbTarget(CLIArguments cfg, String organizationId, String name, String machineId) {
        String entity;
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringBuilder(26).append(this.host()).append("/v1/organizations/").append(organizationId).append("/targets").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Response response = Http$.MODULE$.postJson(url, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"machineId"), (Object)machineId)})), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() == 200 || response.getStatus() == 201) {
            entity = (String)Http$.MODULE$.mapper().readValue(response.getContent(), String.class);
            Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> UUID.fromString(entity));
            if (!result.isSuccess()) {
                throw new Exception(new StringBuilder(18).append("Invalid response: ").append(response.toString()).toString());
            }
        } else {
            throw this.handleError(response, "Error registering target");
        }
        return entity;
    }

    public ZipFile uploadZip(CLIArguments cfg, ZipFile zip) {
        ExchangeDescriptor descriptor;
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        CLILogger$.MODULE$.logInfo(new StringBuilder(14).append("# Uploading ").append(zip.descriptor().groupId()).append(":").append(zip.descriptor().assetId()).append(":").append(zip.descriptor().version()).toString());
        String organizationId = (String)profile.organizationId().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)zip.descriptor().groupUUID().map((Function1 & Serializable & scala.Serializable)x -> x.toString()).orNull(Predef$.MODULE$.$conforms()));
        Predef$.MODULE$.require(organizationId != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot resolve organizationId for the current folder/profile");
        if (zip.descriptor().groupUUID().isDefined()) {
            String string = ((UUID)zip.descriptor().groupUUID().get()).toString();
            String string2 = organizationId;
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append(ExchangeDescriptor$.MODULE$.fileName()).append("::groupId contains a different organizationId than the current worker profile. (").append(zip.descriptor().groupUUID().get()).append(" vs ").append(organizationId).append(")").toString());
        }
        String url = new StringBuilder(28).append(this.host()).append("/v1/organizations/").append(organizationId).append("/assets/").append(zip.descriptor().groupId()).append("/").append(zip.descriptor().assetId()).append("/").append(zip.descriptor().version()).toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Response response = Http$.MODULE$.httpLink().upload(new URL(url), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"file"), (Object)Files.readAllBytes(zip.file().toPath()))}))).asJava(), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        int n = response.getStatus();
        switch (n) {
            case 200: 
            case 201: {
                Option assetDescriptor = Http$.MODULE$.parseJson(response.getContent(), AssetDescriptor.class);
                Predef$.MODULE$.require(assetDescriptor.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Cannot resolve the current asset information");
                String x$7 = ((AssetDescriptor)assetDescriptor.get()).groupId();
                String x$8 = ((AssetDescriptor)assetDescriptor.get()).assetId();
                String x$9 = ((AssetDescriptor)assetDescriptor.get()).version();
                String x$10 = zip.descriptor().copy$default$1();
                String x$11 = zip.descriptor().copy$default$5();
                Option<String> x$12 = zip.descriptor().copy$default$6();
                Option<String> x$13 = zip.descriptor().copy$default$7();
                Option<List<String>> x$14 = zip.descriptor().copy$default$8();
                Option<List<Dependency>> x$15 = zip.descriptor().copy$default$9();
                descriptor = zip.descriptor().copy(x$10, x$7, x$8, x$9, x$11, x$12, x$13, x$14, x$15);
                CLILogger$.MODULE$.logInfo(new StringBuilder(20).append("# Version ").append(descriptor.version()).append(" published").toString());
                break;
            }
            case 400: {
                throw new Exception(new StringBuilder(87).append("Invalid request (missing zip file, file is not zip, malformed or missing `").append(ExchangeDescriptor$.MODULE$.fileName()).append("` file, etc.)").toString());
            }
            case 401: {
                throw new Exception("Unauthorized");
            }
            case 409: {
                throw new Exception("An asset with that group:asset:version already exists");
            }
            default: {
                String entity = cfg.debug() ? new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(response.getContent())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToCharacter((char)CLIXAPI$.$anonfun$uploadZip$6(BoxesRunTime.unboxToByte((Object)x$6))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())))).mkString() : "";
                throw new Exception(new StringBuilder(43).append("Zip asset could not be uploaded, status: ").append(n).append(". ").append(entity).toString());
            }
        }
        return zip.copy(descriptor, zip.copy$default$2(), zip.copy$default$3());
    }

    public Seq<Target> getTargets(CLIArguments cfg, String organizationId) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringBuilder(26).append(this.host()).append("/v1/organizations/").append(organizationId).append("/targets").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        Response response = Http$.MODULE$.httpLink().get(new URL(url), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw this.handleError(response, "Error getting target list");
        }
        return (Seq)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Seq<Target>>(){});
    }

    public Seq<Execution> getExecutions(CLIArguments cfg, String organizationId, int qty) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringBuilder(34).append(this.host()).append("/v1/organizations/").append(organizationId).append("/executions?qty=").append(qty).toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        Response response = Http$.MODULE$.httpLink().get(new URL(url), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw this.handleError(response, "Error getting execution list");
        }
        return (Seq)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Seq<Execution>>(){});
    }

    public int getExecutions$default$3() {
        return 10;
    }

    public CreatedSchedule scheduleTest(CLIArguments cfg, ExchangeDescriptor descriptor, String organizationId, String cron) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        Seq targets = (Seq)this.getTargets(cfg, organizationId).filter((Function1 & Serializable & scala.Serializable)$ -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$scheduleTest$1($)));
        Target target = (Target)cfg.target().map((Function1 & Serializable & scala.Serializable)desiredTarget -> (Target)targets.find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$scheduleTest$3(desiredTarget, x))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Error(new StringBuilder(39).append("Could not find a target that matches '").append((String)desiredTarget).append("'").toString());
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Target)targets.find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$scheduleTest$6(x))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Target)targets.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Error("Could not find a suitable target");
        })));
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("# ").append(target.name()).append(" (").append(target.transport()).append(")").toString());
        CLILogger$.MODULE$.logDebug(new StringBuilder(8).append("target: ").append(target.id()).toString());
        scala.collection.immutable.Map body = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"organizationId"), (Object)organizationId.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configuration"), (Object)cfg.conf()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), (Object)descriptor.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assetId"), (Object)descriptor.assetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)descriptor.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)target.id()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"CRON_EXPRESSION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)cron), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cron"), (Object)cron)}));
        String url = new StringBuilder(36).append(this.host()).append("/v1/organizations/").append(organizationId.toString()).append("/tests/").append(descriptor.groupId()).append(":").append(descriptor.assetId()).append("/schedules").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Response response = Http$.MODULE$.postJson(url, (Object)body, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw this.handleError(response, "Error scheduling the test");
        }
        return (CreatedSchedule)Http$.MODULE$.parseResponseJson(response, CreatedSchedule.class);
    }

    public Nothing$ handleError(Response response, String messagePrefix) {
        ObjectRef message = ObjectRef.create((Object)None$.MODULE$);
        Exception$.MODULE$.ignoring((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class})).apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            message$1.elem = new Some((Object)((CLIXAPI.ErrorMessage)Http$.MODULE$.parseResponseJson(response, CLIXAPI.ErrorMessage.class)).text().message());
        });
        throw new Exception(new StringBuilder(2).append(messagePrefix).append(": ").append(((Option)message.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown error")).toString());
    }

    public Option<DumbExecution> createLocalExecution(CLIArguments cfg) {
        ExchangeDescriptor descriptor = BatPackageCommands$.MODULE$.getExchangeDescriptor(cfg);
        descriptor.ensureValidGAV();
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        CurrentWorker target = BatWorkerCommands$.MODULE$.ensureCurrentWorker(cfg);
        if (descriptor.groupUUID().isDefined()) {
            String string = ((UUID)descriptor.groupUUID().get()).toString();
            String string2 = target.organizationId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append(ExchangeDescriptor$.MODULE$.fileName()).append("::groupId contains a different organizationId than the current worker profile. (").append(descriptor.groupUUID().get()).append(" vs ").append(target.organizationId()).append(")").toString());
        }
        scala.collection.immutable.Map body = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), (Object)descriptor.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assetId"), (Object)descriptor.assetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)descriptor.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configuration"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)target.targetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scheduleId"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"artifactId"), null)}));
        String url = new StringBuilder(29).append(this.host()).append("/v1/organizations/").append(target.organizationId()).append("/executions").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Response response = Http$.MODULE$.postJson(url, (Object)body, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw this.handleError(response, "Error registering execution");
        }
        return Http$.MODULE$.parseJson(response.getContent(), DumbExecution.class);
    }

    public void logout(CredentialsProfile profile) {
        String token = ((Token)profile.token().get()).token();
        CLILogger$.MODULE$.logDebug("Trying to logout");
        String url = new StringBuilder(16).append(this.host()).append("/v1/auth/logout/").append(token).toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(7).append("DELETE ").append(url).toString());
        Option option = Option$.MODULE$.apply((Object)Http$.MODULE$.delete(url, token));
        if (None$.MODULE$.equals(option)) {
            throw new Exception("Logout with credentials failed.");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Response r = (Response)some.value();
            CLILogger$.MODULE$.logDebug(r);
            int n = r.getStatus();
            switch (n) {
                case 200: {
                    None$ x$16 = None$.MODULE$;
                    String x$17 = profile.copy$default$1();
                    String x$18 = profile.copy$default$2();
                    String x$19 = profile.copy$default$3();
                    Option<String> x$20 = profile.copy$default$4();
                    Option<String> x$21 = profile.copy$default$5();
                    Option<String> x$22 = profile.copy$default$6();
                    Option<String> x$23 = profile.copy$default$7();
                    profile.copy(x$17, x$18, x$19, x$20, x$21, x$22, x$23, (Option<Token>)x$16).updateProfile();
                    break;
                }
                case 401: {
                    throw new Exception("401 Unauthorized");
                }
                default: {
                    throw new Exception(new StringBuilder(22).append("Logout failed. Status ").append(n).toString());
                }
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public String ACCESS_TOKEN() {
        return this.ACCESS_TOKEN;
    }

    public Token login(CLIArguments cfg, CredentialsProfile profile) {
        if (profile.isValid()) {
            return (Token)profile.token().get();
        }
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(profile.username())).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(profile.password())).nonEmpty() || profile.token().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Username/Password or token is required");
        ConfigureCLIUrls$.MODULE$.configureWithHost(profile.host());
        CLILogger$.MODULE$.logDebug("Trying to login");
        String string = profile.password();
        String string2 = this.ACCESS_TOKEN();
        if (!(string == null ? string2 != null : !string.equals(string2)) || profile.password().isEmpty() && profile.token().nonEmpty()) {
            this.loginWithToken(profile);
        } else {
            this.loginWithUserAndPass(profile);
        }
        if (profile.token().isEmpty()) {
            throw new Exception("Invalid token");
        }
        return (Token)profile.token().get();
    }

    public void loginWithToken(CredentialsProfile profile) {
        String url = new StringBuilder(11).append(this.host()).append("/v1/auth/me").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(4).append("GET ").append(url).toString());
        Option option = Option$.MODULE$.apply((Object)Http$.MODULE$.get(url, ((Token)profile.token().get()).token()));
        if (None$.MODULE$.equals(option)) {
            throw new Exception("Login with credentials failed.");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Response r = (Response)some.value();
            CLILogger$.MODULE$.logDebug(r);
            int n = r.getStatus();
            switch (n) {
                case 200: {
                    ProfileResponse x = (ProfileResponse)Http$.MODULE$.parseResponseJson(r, ProfileResponse.class);
                    profile.token_$eq((Option<Token>)new Some((Object)new Token(x.access_token().access_token(), System.currentTimeMillis() / 1000L)));
                    profile.organizationId_$eq((Option<String>)new Some((Object)x.user().organization().id()));
                    profile.organization_$eq((Option<String>)new Some((Object)x.user().organization().name()));
                    profile.username_$eq(x.user().username());
                    profile.password_$eq(this.ACCESS_TOKEN());
                    profile.updateProfile();
                    break;
                }
                case 401: {
                    throw new Exception("401 Unauthorized");
                }
                default: {
                    throw new Exception(new StringBuilder(22).append("Login failed.  Status ").append(n).toString());
                }
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void loginWithUserAndPass(CredentialsProfile profile) {
        String url = new StringBuilder(14).append(this.host()).append("/v1/auth/login").toString();
        CLILogger$.MODULE$.logDebug(new StringBuilder(5).append("POST ").append(url).toString());
        Option option = Option$.MODULE$.apply((Object)Http$.MODULE$.postJson(url, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)profile.username()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)profile.password())})), Http$.MODULE$.postJson$default$3()));
        if (None$.MODULE$.equals(option)) {
            throw new Exception("Login with credentials failed.");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Response r = (Response)some.value();
            CLILogger$.MODULE$.logDebug(r);
            int n = r.getStatus();
            switch (n) {
                case 200: 
                case 201: {
                    LoginResponse x = (LoginResponse)Http$.MODULE$.parseResponseJson(r, LoginResponse.class);
                    profile.token_$eq((Option<Token>)new Some((Object)new Token(x.token(), System.currentTimeMillis() / 1000L)));
                    if (profile.organizationId().isEmpty() && x.organizationId().nonEmpty()) {
                        profile.organizationId_$eq(x.organizationId());
                        profile.organization_$eq(x.organizationName());
                    } else if (profile.organizationId().isEmpty() && x.organizations().nonEmpty()) {
                        profile.organizationId_$eq((Option<String>)new Some((Object)((LoginResponseOrganization)x.organizations().head()).id()));
                        profile.organization_$eq((Option<String>)new Some((Object)((LoginResponseOrganization)x.organizations().head()).name()));
                    }
                    profile.updateProfile();
                    break;
                }
                case 401: {
                    throw new Exception("401 Unauthorized");
                }
                default: {
                    throw new Exception(new StringBuilder(21).append("Login failed. Status ").append(n).toString());
                }
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$grant$2(String secretGroupName$1, SecretGroup x$1) {
        String string = x$1.secretGroupName();
        String string2 = secretGroupName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$grant$5(Secret x$24, String x$2) {
        String string = x$2;
        String string2 = x$24.secretName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$grant$4(scala.collection.immutable.Map secretNames$1, Secret x) {
        return secretNames$1.values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$grant$5(x, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$grant$10(String name$1, Secret x$4) {
        String string = x$4.secretName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$grant$11(Secret s$1, AccessGrant x$5) {
        String string = x$5.path();
        String string2 = s$1.secretPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ char $anonfun$uploadZip$6(byte x$6) {
        return (char)x$6;
    }

    public static final /* synthetic */ boolean $anonfun$scheduleTest$1(Target $) {
        String string = $.transport();
        String string2 = "DUMB";
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$scheduleTest$3(String desiredTarget$1, Target x) {
        String string = x.name();
        String string2 = desiredTarget$1;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = x.id();
        String string4 = desiredTarget$1;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$scheduleTest$6(Target x) {
        return x.organizationId().isEmpty() || x.organizationId() == new Some((Object)"public");
    }

    private CLIXAPI$() {
        MODULE$ = this;
        this.host = "https://anypoint.mulesoft.com/apitesting/cli/api";
        this.ACCESS_TOKEN = "~~~ACESSS_TOKEN~~~";
    }
}

