/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.topbraid.jenax.statistics.ExecStatistics;
import org.topbraid.jenax.statistics.ExecStatisticsListener;

public class ExecStatisticsManager {
    private static ExecStatisticsManager singleton = new ExecStatisticsManager();
    private Set<ExecStatisticsListener> listeners = new HashSet<ExecStatisticsListener>();
    private boolean recording;
    private boolean recordingNativeFunctions;
    private boolean recordingDeclarativeFunctions;
    private List<ExecStatistics> stats = Collections.synchronizedList(new LinkedList());

    public static ExecStatisticsManager get() {
        return singleton;
    }

    public void addListener(ExecStatisticsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void add(Iterable<ExecStatistics> values) {
        this.addSilently(values);
        this.notifyListeners();
    }

    public void addSilently(Iterable<ExecStatistics> values) {
        for (ExecStatistics s : values) {
            this.stats.add(s);
        }
    }

    public synchronized List<ExecStatistics> getStatistics() {
        return this.stats;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isRecordingDeclarativeFunctions() {
        return this.recordingDeclarativeFunctions;
    }

    public boolean isRecordingNativeFunctions() {
        return this.recordingNativeFunctions;
    }

    public void removeListener(ExecStatisticsListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void reset() {
        this.stats.clear();
        this.notifyListeners();
    }

    public void notifyListeners() {
        for (ExecStatisticsListener listener : new ArrayList<ExecStatisticsListener>(this.listeners)) {
            listener.statisticsUpdated();
        }
    }

    public void setRecording(boolean value) {
        this.recording = value;
    }

    public void setRecordingDeclarativeFunctions(boolean value) {
        this.recordingDeclarativeFunctions = value;
    }

    public void setRecordingNativeFunctions(boolean value) {
        this.recordingNativeFunctions = value;
    }
}

