import HttpClientResult from dw::http::Types
import * from bat::core::AssertionHelpers
import bat from bat::core::AssertionHelpers
import * from bat::Types
import fail as raiseError from dw::Runtime

ns bat http://mulesoft.com/ns/bat

import executeAssertions, computePass, executeStatements, executeAssertion from bat::core::Helpers

// ASSERTIONS ==========================================================================================================

fun assert<T>(batResult: BATPassCapable<T>, assertions: Array<(result: T) -> BATAssertion | Boolean>) =
  if (batResult.pass == false)
    batResult
  else do {
    var newAssertions = executeAssertions(batResult.result, assertions)
    var newResult = (batResult - "assertions") ++ {
      assertions: (batResult.assertions default []) ++ newAssertions
    }
    ---
    (newResult - "pass") ++ {
      pass: computePass(newResult.assertions)
    }
  }

fun assert(assertion: () -> (BATAssertion | Boolean), name: String) = do {
  executeAssertion(name, assertion)
}

fun assert(assertion: BATAssertion | Boolean, name: String) = do {
  executeAssertion(name, () -> assertion)
}


// EXECUTE =============================================================================================================

fun execute<T>(batResult: BATPassCapable<T>, statements: Array<(result: T) -> Any>) = do {
  var results = executeStatements(batResult.result, statements)
  var newResult = (batResult - "assertions") ++ {
    assertions: (batResult.assertions default []) ++ results
  }
  ---
  (newResult - "pass") ++ {
    pass: computePass(newResult.assertions)
  }
}

// MATCHERS ============================================================================================================

fun mustBeLike<A,B>(a: A, b: B): BATAssertion = do {
  fun privateMatchLike_<T, V>(value: T, comparator: V): Boolean =
    if(value ~= comparator)
      true
    else
      comparator match {
        case a if isOneOf_(a) ->
          (a as Object).bat#items reduce (comparator, acc = false) -> (acc or privateMatchLike_(value, comparator))
        else -> false
      }
  ---
  {
    kind: "Assertion",
    pass:
      if(isEvery_(a))
        computeEvery_((a as Object).bat#items, (a) -> privateMatchLike_(a, b))
      else if(isSome_(a))
        computeSome_((a as Object).bat#items, (a) -> privateMatchLike_(a, b))
      else
        privateMatchLike_(a, b),
    name: "$(matchPrinter_(a)) must be similar to $(matchPrinter_(b))",
    softFail: false,
    result: {
      kind: "Assertion::Similar",
      expectedValue: write(b),
      givenValue: write(a)
    }
  } as BATAssertion
}

fun mustEqual<A, B>(a: A, b: B): BATAssertion = do {
  fun privateMatchEqual_<T, V>(value: T, comparator: V): Boolean =
    if(value == comparator)
      true
    else
      comparator match {
        case a if isOneOf_(a) ->
          (a as Object).bat#items reduce (comparator, acc = false) -> (acc or privateMatchEqual_(value, comparator))
        else -> false
      }
  ---
  {
    kind: "Assertion",
    pass:
      if(isEvery_(a))
        computeEvery_((a as Object).bat#items, (a) -> privateMatchEqual_(a, b))
      else if(isSome_(a))
        computeSome_((a as Object).bat#items, (a) -> privateMatchEqual_(a, b))
      else
        privateMatchEqual_(a, b),
    name: "$(matchPrinter_(a)) must equal $(matchPrinter_(b))",
    softFail: false,
    result: {
      kind: "Assertion::Equal",
      expectedValue: write(b),
      givenValue: write(a)
    }
  } as BATAssertion
}

fun mustMatch<T, V>(a: T, b: () -> V): BATAssertion = do {
  fun privateMatch_<T, V>(value: T, comparator: V): Boolean =
    if(value == comparator)
      true
    else comparator match {
      case is Regex ->
        value match {
          case is Number -> value as String contains comparator
          case is String -> value contains comparator
          else -> false
        }
      case a if isOneOf_(a) ->
        (a as Object).bat#items reduce (comparator, acc = false) -> (acc or privateMatch_(value, comparator))
      // partial object matching
      case is Object ->
        if (value is Object)
          comparator pluck $$ reduce (key, acc = true) -> (acc and privateMatch_(value[key], comparator[key]))
        else
          false
      else -> false
    }
  ---
  {
    kind: "Assertion",
    pass:
      if(isEvery_(a))
        computeEvery_((a as Object).bat#items, (a) -> privateMatch_(a, b()))
      else if(isSome_(a))
        computeSome_((a as Object).bat#items, (a) -> privateMatch_(a, b()))
      else
        privateMatch_(a, b()),
    name: "$(matchPrinter_(a)) must match $(matchPrinter_(b()) as String)",
    softFail: false,
    result: {
      kind: "Assertion::Matcher",
      expectedValue: write(b()),
      givenValue: write(a)
    }
  } as BATAssertion
}

fun oneOf<T>(a: Array<T>): MatchesOneOf<T> = {
  bat#matchesOneOf: true,
  bat#items: a
}

fun some<T>(a: Array<T>): EveryItem<T> = {
  bat#everyItem: false,
  bat#items: a
}

fun some(a: Null): EveryItem<Nothing> = {
  bat#everyItem: false,
  bat#items: []
}

fun every<T>(a: Array<T>): EveryItem<T> = {
  bat#everyItem: true,
  bat#items: a
}

fun every(a: Null): EveryItem<Nothing> = {
  bat#everyItem: true,
  bat#items: []
}






