import * from bat::Types
import DEBUG from bat::core::Console
import * from dw::http::Client
import * from dw::Runtime

output application/json


fun webHook() =
  if(options != null and options.SLACK_WEBHOOK?)
    options.SLACK_WEBHOOK
  else if((dw::System::envVar('SLACK_WEBHOOK') default '') != '')
    dw::System::envVar('SLACK_WEBHOOK')
  else
    log('Missing SLACK_WEBHOOK env variable or option', '')



fun matching(result) = result.kind match {
    case "TEST" -> flatten(result.result)
    case "LOOPABLE" -> flatten(result.result)
    case "SUITE" -> flatten(result.result)
    case "HTTP" -> [result]
    else -> []
}

fun processHttp(http) = do {
    http.name
}
fun flatten(results) = do {
    (results flatMap ((item, index) -> (matching(item)) filter not $.pass))
}

fun reason(r, kind) = do {
    kind match {
        case "Assertion" ->
            r.kind match {
                case "Assertion::Equal" -> r.givenValue ++ " was not equal to " ++ r.expectedValue
                case "Assertion::Matcher" -> r.givenValue ++ " does not match " ++ r.expectedValue
                case "Assertion::Similar" -> r.givenValue ++ " is not similar to " ++ r.expectedValue
                else  -> "Assertion failed "
            }
        case "RuntimeException" -> "Exception: " ++ r.message
        else -> "Assertion failed"
    }

}
fun processAssertions(assertions) = do {
    assertions filter not $.pass map ("- " ++ $.name ++ " `( " ++ (reason($.result, $.kind)) ++ " ) ` :exclamation:")
}

fun post(url, body) = do {
   var r = request('POST',url,body)
   ---
   if(r.err)
      fail("Slack notification failed: " ++ r.message)
   else if(r.response.status != 200)
      fail("Slack notification failed: " ++ r.response.payload)
   else body
}

fun process(payload) = {  text: "*" ++ payload.name ++"* Failed\n\t" ++ (flatten (payload.result)  map ("The following assertions for `" ++ $.name ++ "` have failed:\n\t\t" ++ ( processAssertions($.assertions)  reduce ($$ ++ "\n\t\t" ++$))))[0] }
---
if (DEBUG or webHook() == '')
  process(payload)
else if (payload.pass == false)
  post(webHook(), {
    body: process(payload),
  })
else payload



