/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import com.google.common.collect.ImmutableList;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.Optional;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.internal.TemporalFormatValidator;

public class DateTimeFormatValidator
implements FormatValidator {
    private static final List<String> FORMATS_ACCEPTED = ImmutableList.of((Object)"yyyy-MM-dd'T'HH:mm:ssZ", (Object)"yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,9}Z, yyyy-MM-dd'T'HH:mm:ss[+-]HH:mm", (Object)"yyyy-MM-dd'T'HH:mm:ss.[0-9]{1,9}[+-]HH:mm");
    private static final String PARTIAL_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateTimeFormatter FORMATTER;
    private Delegate delegate = new Delegate();

    @Override
    public Optional<String> validate(String subject) {
        return this.delegate.validate(subject);
    }

    @Override
    public String formatName() {
        return "date-time";
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendPattern(PARTIAL_DATETIME_PATTERN).appendOptional(TemporalFormatValidator.SECONDS_FRACTION_FORMATTER).appendPattern("XXX");
        FORMATTER = builder.toFormatter();
    }

    private static class Delegate
    extends TemporalFormatValidator {
        Delegate() {
            super(FORMATTER, FORMATS_ACCEPTED);
        }

        @Override
        public String formatName() {
            return "date-time";
        }
    }
}

