/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.runner.pipeline;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.mulesoft.bat.dw.csm.CSMSecretsProvider;
import com.mulesoft.bat.dw.dao.BATTestResult;
import com.mulesoft.bat.dw.service.BatLoggingService;
import com.mulesoft.bat.runner.apis.Endpoints;
import com.mulesoft.bat.runner.apis.WorkerAPI;
import com.mulesoft.bat.runner.compiler.BatCompiler;
import com.mulesoft.bat.runner.compiler.ContextRunnerFactory;
import com.mulesoft.bat.runner.lambda.HttpLink;
import com.mulesoft.bat.runner.lambda.Response;
import com.mulesoft.bat.runner.model.BatProjectArtifactId;
import com.mulesoft.bat.runner.model.BatReporter;
import com.mulesoft.bat.runner.model.BatSecret;
import com.mulesoft.bat.runner.model.BatSpec;
import com.mulesoft.bat.runner.model.DistributionType$;
import com.mulesoft.bat.runner.model.Execution;
import com.mulesoft.bat.runner.pipeline.BatExecutableProject;
import com.mulesoft.bat.runner.service.ServicesSwitcher$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.ServiceManager$;
import org.mule.weave.v2.model.service.LoggingService;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\u000f\u001f\u0003\u0003I\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\t\u0011y\u0002!\u0011!Q\u0001\naB\u0001b\u0010\u0001\u0003\u0006\u0004%\u0019\u0001\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0001\n\u0001B\u0001B\u0003-\u0011\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"Ia\r\u0001a\u0001\u0002\u0004%\ta\u001a\u0005\n[\u0002\u0001\r\u0011!Q!\neCQA\u001c\u0001\u0007\u0002=DQ\u0001\u001f\u0001\u0005\u0002eDq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011\u0011\u000e\u0001\u0007\u0002\u0005-\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u007f\u0002A\u0011AA?\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Cq!a%\u0001\t\u0003\t)\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAc\u0001\u0019\u0005\u0011q\u0019\u0005\b\u0003+\u0004a\u0011AAl\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDqA!\u0002\u0001\t\u0003\u00119\u0001C\u0004\u0003&\u0001!\tAa\n\t\u000f\t-\u0002\u0001\"\u0001\u0003.\tY!)\u0019;QSB,G.\u001b8f\u0015\ty\u0002%\u0001\u0005qSB,G.\u001b8f\u0015\t\t#%\u0001\u0004sk:tWM\u001d\u0006\u0003G\u0011\n1AY1u\u0015\t)c%\u0001\u0005nk2,7o\u001c4u\u0015\u00059\u0013aA2p[\u000e\u00011c\u0001\u0001+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0011\u0002\t\u0005\u0004\u0018n]\u0005\u0003kI\u0012\u0011bV8sW\u0016\u0014\u0018\tU%\u0002\u0013\u0015DXmY;uS>tW#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u0002\u0013!B7pI\u0016d\u0017BA\u001f;\u0005%)\u00050Z2vi&|g.\u0001\u0006fq\u0016\u001cW\u000f^5p]\u0002\n1BY1u\u0007>l\u0007/\u001b7feV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002EA\u0005A1m\\7qS2,'/\u0003\u0002G\u0007\nY!)\u0019;D_6\u0004\u0018\u000e\\3s\u00031\u0011\u0017\r^\"p[BLG.\u001a:!\u0003\t)7\r\u0005\u0002K\u001b6\t1J\u0003\u0002MY\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00059[%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011+\u0016,\u0015\u0005I#\u0006CA*\u0001\u001b\u0005q\u0002\"\u0002%\u0007\u0001\bI\u0005\"\u0002\u001c\u0007\u0001\u0004A\u0004\"B \u0007\u0001\b\t\u0015AD:feZL7-Z'b]\u0006<WM]\u000b\u00023B\u0011!\fZ\u0007\u00027*\u00111\b\u0018\u0006\u0003;z\u000b!A\u001e\u001a\u000b\u0005}\u0003\u0017!B<fCZ,'BA1c\u0003\u0011iW\u000f\\3\u000b\u0003\r\f1a\u001c:h\u0013\t)7L\u0001\bTKJ4\u0018nY3NC:\fw-\u001a:\u0002%M,'O^5dK6\u000bg.Y4fe~#S-\u001d\u000b\u0003Q.\u0004\"aK5\n\u0005)d#\u0001B+oSRDq\u0001\u001c\u0005\u0002\u0002\u0003\u0007\u0011,A\u0002yIE\nqb]3sm&\u001cW-T1oC\u001e,'\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0003A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u000fM,'O^5dK*\u0011QOI\u0001\u0003I^L!a\u001e:\u0003#\t\u000bG\u000fT8hO&twmU3sm&\u001cW-A\u0006tK:$'+Z:vYR\u001cHC\u0001>~!\rQ5\u0010[\u0005\u0003y.\u0013aAR;ukJ,\u0007\"\u0002@\f\u0001\u0004y\u0018aC7bs\n,'+Z:vYR\u0004RaKA\u0001\u0003\u000bI1!a\u0001-\u0005\u0019y\u0005\u000f^5p]B!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fQ\f1\u0001Z1p\u0013\u0011\ty!!\u0003\u0003\u001b\t\u000bE\u000bV3tiJ+7/\u001e7u\u0003-qw\u000e^5gs\u0016\u0013(o\u001c:\u0015\u0007i\f)\u0002C\u0004\u0002\u00181\u0001\r!!\u0007\u0002\u0003\u0015\u0004B!a\u0007\u0002,9!\u0011QDA\u0014\u001d\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012Q\u00051AH]8pizJ\u0011!L\u0005\u0004\u0003Sa\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003[\tyCA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011\u0006\u0017\u0002\u001f\u001d,G/\u0012=ue\u0006\u001cuN\u001c;fqR,\"!!\u000e\u0011\t)[\u0018q\u0007\t\u0006W\u0005\u0005\u0011\u0011\b\t\t\u0003w\t\u0019%!\u0013\u0002P9!\u0011QHA !\r\ty\u0002L\u0005\u0004\u0003\u0003b\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#aA'ba*\u0019\u0011\u0011\t\u0017\u0011\t\u0005m\u00121J\u0005\u0005\u0003\u001b\n9E\u0001\u0004TiJLgn\u001a\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!!\u0018\u0002T\t1qJ\u00196fGR\fq![:EK\n,x-\u0006\u0002\u0002dA\u00191&!\u001a\n\u0007\u0005\u001dDFA\u0004C_>dW-\u00198\u0002!\u0011|wO\u001c7pC\u0012\f%\u000f^5gC\u000e$HCAA7!\u0011Q50a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u001e\u0002X\u0005\u0019a.\u001a;\n\t\u0005e\u00141\u000f\u0002\u0004+Jc\u0015\u0001E5oSRL\u0017\r\\5{KJ+hN\\3s)\u0005Q\u0018A\u00044j]\u0006d\u0017N_3Sk:tWM]\u0001\u0012O\u0016$X\t\u001f;sCJ+\u0007o\u001c:uKJ\u001cXCAAC!\u0011Q50a\"\u0011\r\u0005m\u0011\u0011RAG\u0013\u0011\tY)a\f\u0003\t1K7\u000f\u001e\t\u0004s\u0005=\u0015bAAIu\tY!)\u0019;SKB|'\u000f^3s\u0003=\u0011WMZ8sK\u0016CXmY;uS>tGc\u0001>\u0002\u0018\"9\u0011\u0011T\nA\u0002\u0005m\u0015a\u00022biN\u0003Xm\u0019\t\u0004s\u0005u\u0015bAAPu\t9!)\u0019;Ta\u0016\u001c\u0017\u0001D4fi\u000ec\u0017m]:QCRDWCAAS!\u0011Q50a*\u0011\u000b-\nI+a\u001c\n\u0007\u0005-FFA\u0003BeJ\f\u00170\u0001\u0007hKR\u001cF/\u0019:u\r&dW-\u0006\u0002\u00022B!!j_AZ!\u0015Y\u0013\u0011AA%\u0003M9W\r^#yK\u000e,H/[8o)&lWm\\;u+\t\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\tylS\u0001\tIV\u0014\u0018\r^5p]&!\u00111YA_\u0005!!UO]1uS>t\u0017aD:fGJ,Go\u001d)s_ZLG-\u001a:\u0016\u0005\u0005%\u0007\u0003BAf\u0003#l!!!4\u000b\u0007\u0005=G/A\u0002dg6LA!a5\u0002N\n\u00112iU'TK\u000e\u0014X\r^:Qe>4\u0018\u000eZ3s\u0003Q\u0019wN\u001c;fqR\u0014VO\u001c8fe\u001a\u000b7\r^8ssV\u0011\u0011\u0011\u001c\t\u0004\u0005\u0006m\u0017bAAo\u0007\n!2i\u001c8uKb$(+\u001e8oKJ4\u0015m\u0019;pef\f\u0001\u0003Z5tiJL'-\u001e;j_:$\u0016\u0010]3\u0016\u0005\u0005\r\b\u0003BAs\u0003\u007ftA!a:\u0002|:!\u0011\u0011^A}\u001d\u0011\tY/a>\u000f\t\u00055\u0018Q\u001f\b\u0005\u0003_\f\u0019P\u0004\u0003\u0002 \u0005E\u0018\"A\u0014\n\u0005\u00152\u0013BA\u0012%\u0013\t\t#%\u0003\u0002<A%\u0019\u0011Q \u001e\u0002!\u0011K7\u000f\u001e:jEV$\u0018n\u001c8UsB,\u0017\u0002\u0002B\u0001\u0005\u0007\u0011\u0001\u0003R5tiJL'-\u001e;j_:$\u0016\u0010]3\u000b\u0007\u0005u((\u0001\u000bhKR,\u00050Z2vi\u0006\u0014G.\u001a)s_*,7\r\u001e\u000b\t\u0005\u0013\u0011\tB!\u0006\u0003\"A!!j\u001fB\u0006!\r\u0019&QB\u0005\u0004\u0005\u001fq\"\u0001\u0006\"bi\u0016CXmY;uC\ndW\r\u0015:pU\u0016\u001cG\u000fC\u0004\u0003\u0014i\u0001\r!a-\u0002\u001d5\f\u0017PY3Ti\u0006\u0014HOR5mK\"9!q\u0003\u000eA\u0002\te\u0011aD7bs\n,\u0017I\u001d;jM\u0006\u001cG/\u00133\u0011\u000b-\n\tAa\u0007\u0011\u0007e\u0012i\"C\u0002\u0003 i\u0012ACQ1u!J|'.Z2u\u0003J$\u0018NZ1di&#\u0007b\u0002B\u00125\u0001\u0007\u0011qU\u0001\nG2\f7o\u001d9bi\"\fQbZ3u\u0003J$\u0018NZ1di&#WC\u0001B\u0015!\u0011Q5P!\u0007\u0002\u0007I,h\u000e\u0006\u0002\u00030A\u0019!j_@")
public abstract class BatPipeline
implements WorkerAPI {
    private final Execution execution;
    private final BatCompiler batCompiler;
    private final ExecutionContext ec;
    private ServiceManager serviceManager;
    private String coreServicesEndpoint;
    private String workerAPIEndpoint;
    private final HttpLink http;
    private final scala.collection.concurrent.Map<String, File> artifactsCache;

    @Override
    public void setEndpoints(Endpoints endpoints) {
        WorkerAPI.setEndpoints$(this, endpoints);
    }

    @Override
    public void logDebug(Response response) {
        WorkerAPI.logDebug$(this, response);
    }

    @Override
    public Map<String, BatSecret> getSecrets(Map<String, BatSecret> secretsInfo, Option<String> targetId, Option<String> orgId, Option<String> targetSecret, Option<String> token) {
        return WorkerAPI.getSecrets$(this, secretsInfo, targetId, orgId, targetSecret, token);
    }

    @Override
    public Option<String> getSecrets$default$5() {
        return WorkerAPI.getSecrets$default$5$(this);
    }

    @Override
    public void removeFile(String key, File value, RemovalCause removalCause) {
        WorkerAPI.removeFile$(this, key, value, removalCause);
    }

    @Override
    public File getArtifact(String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret, scala.collection.concurrent.Map<String, File> artifactsCache) {
        return WorkerAPI.getArtifact$(this, organizationId, artifactId, executionId, testId, token, targetId, targetSecret, artifactsCache);
    }

    @Override
    public scala.collection.concurrent.Map<String, File> getArtifact$default$8() {
        return WorkerAPI.getArtifact$default$8$(this);
    }

    @Override
    public File getArtifactNow(File localFile, String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        return WorkerAPI.getArtifactNow$(this, localFile, organizationId, artifactId, executionId, testId, token, targetId, targetSecret);
    }

    @Override
    public boolean uploadResult(String organizationId, String executionId, String testId, byte[] result, Option<byte[]> analytics, String token, Option<String> targetId, Option<String> targetSecret) {
        return WorkerAPI.uploadResult$(this, organizationId, executionId, testId, result, analytics, token, targetId, targetSecret);
    }

    @Override
    public boolean setStatus(String organizationId, String executionId, String testId, String token, String status, Option<String> targetId, Option<String> targetSecret) {
        return WorkerAPI.setStatus$(this, organizationId, executionId, testId, token, status, targetId, targetSecret);
    }

    @Override
    public String coreServicesEndpoint() {
        return this.coreServicesEndpoint;
    }

    @Override
    public void coreServicesEndpoint_$eq(String x$1) {
        this.coreServicesEndpoint = x$1;
    }

    @Override
    public String workerAPIEndpoint() {
        return this.workerAPIEndpoint;
    }

    @Override
    public void workerAPIEndpoint_$eq(String x$1) {
        this.workerAPIEndpoint = x$1;
    }

    @Override
    public HttpLink http() {
        return this.http;
    }

    @Override
    public scala.collection.concurrent.Map<String, File> artifactsCache() {
        return this.artifactsCache;
    }

    @Override
    public void com$mulesoft$bat$runner$apis$WorkerAPI$_setter_$http_$eq(HttpLink x$1) {
        this.http = x$1;
    }

    @Override
    public void com$mulesoft$bat$runner$apis$WorkerAPI$_setter_$artifactsCache_$eq(scala.collection.concurrent.Map<String, File> x$1) {
        this.artifactsCache = x$1;
    }

    public Execution execution() {
        return this.execution;
    }

    public BatCompiler batCompiler() {
        return this.batCompiler;
    }

    public ServiceManager serviceManager() {
        return this.serviceManager;
    }

    public void serviceManager_$eq(ServiceManager x$1) {
        this.serviceManager = x$1;
    }

    @Override
    public abstract BatLoggingService logger();

    public Future<BoxedUnit> sendResults(Option<BATTestResult> maybeResult) {
        return Future$.MODULE$.unit();
    }

    public Future<BoxedUnit> notifyError(Throwable e) {
        this.logger().logError("*** Error ***");
        this.logger().logError(e.getMessage());
        return Future$.MODULE$.unit();
    }

    public Future<Option<Map<String, Object>>> getExtraContext() {
        return Future$.MODULE$.successful((Object)None$.MODULE$);
    }

    public boolean isDebug() {
        return false;
    }

    public abstract Future<URL> downloadArtifact();

    public Future<BoxedUnit> initializeRunner() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.serviceManager_$eq(ServiceManager$.MODULE$.apply((LoggingService)this.logger()));
            this.serviceManager().registerService(CSMSecretsProvider.class, (Object)this.secretsProvider());
            ServicesSwitcher$.MODULE$.configureVariableServices(this.serviceManager(), this.distributionType());
        }, this.ec);
    }

    public Future<BoxedUnit> finalizeRunner() {
        return Future$.MODULE$.unit();
    }

    public Future<List<BatReporter>> getExtraReporters() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, this.ec);
    }

    public Future<BoxedUnit> beforeExecution(BatSpec batSpec) {
        return Future$.MODULE$.unit();
    }

    public Future<URL[]> getClassPath() {
        return this.downloadArtifact().map((Function1 & Serializable & scala.Serializable)x$1 -> (URL[])((Object[])new URL[]{x$1}), this.ec);
    }

    public Future<Option<String>> getStartFile() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, this.ec);
    }

    public Duration getExecutionTimeout() {
        return new package.DurationInt(package$.MODULE$.DurationInt(30)).minutes();
    }

    public abstract CSMSecretsProvider secretsProvider();

    public abstract ContextRunnerFactory contextRunnerFactory();

    public Enumeration.Value distributionType() {
        return DistributionType$.MODULE$.Cli();
    }

    public Future<BatExecutableProject> getExecutableProject(Option<String> maybeStartFile, Option<BatProjectArtifactId> maybeArtifactId, URL[] classpath) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new BatExecutableProject(this.execution(), maybeArtifactId, maybeStartFile, this.contextRunnerFactory().createContextRunner(classpath), this.isDebug(), this.getExecutionTimeout(), this.distributionType()), this.ec);
    }

    public Future<Option<BatProjectArtifactId>> getArtifactId() {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Execution execution = this.execution();
            if (execution == null) return None$.MODULE$;
            Option<String> option = execution.organizationId();
            Option<String> option2 = execution.testId();
            Option<String> option3 = execution.artifactId();
            if (!(option instanceof Some)) return None$.MODULE$;
            Some some = (Some)option;
            String o = (String)some.value();
            if (!(option2 instanceof Some)) return None$.MODULE$;
            Some some2 = (Some)option2;
            String t = (String)some2.value();
            if (!(option3 instanceof Some)) return None$.MODULE$;
            Some some3 = (Some)option3;
            String a = (String)some3.value();
            return new Some((Object)new BatProjectArtifactId(o, t, a));
        }, this.ec);
    }

    public Future<Option<BATTestResult>> run() {
        this.logger().logDebug("*** Starting Pipeline ***");
        return this.initializeRunner().flatMap((Function1 & Serializable & scala.Serializable)_ -> {
            this.logger().logDebug("*** Building classpath ***");
            return this.getClassPath().flatMap((Function1 & Serializable & scala.Serializable)classpath -> {
                this.logger().logDebug("*** Building artifactId ***");
                return this.getArtifactId().flatMap((Function1 & Serializable & scala.Serializable)maybeArtifactId -> {
                    this.logger().logDebug("*** Resolving start file ***");
                    return this.getStartFile().flatMap((Function1 & Serializable & scala.Serializable)maybeStartFile -> {
                        this.logger().logDebug("*** Configuring project ***");
                        return this.getExecutableProject((Option<String>)maybeStartFile, (Option<BatProjectArtifactId>)maybeArtifactId, (URL[])classpath).flatMap((Function1 & Serializable & scala.Serializable)project -> {
                            this.logger().logDebug("*** Looking for extra reporters ***");
                            return this.getExtraReporters().flatMap((Function1 & Serializable & scala.Serializable)extraReporters -> {
                                this.logger().logDebug("*** Building extra context ***");
                                return this.getExtraContext().flatMap((Function1 & Serializable & scala.Serializable)extraContext -> {
                                    this.logger().logDebug("*** Running tests ***");
                                    return project.run(this.logger(), this.serviceManager(), (List<BatReporter>)extraReporters, (Option<Map<String, Object>>)extraContext, (Function1<BatSpec, Future<BoxedUnit>>)(Function1 & Serializable & scala.Serializable)batSpec -> this.beforeExecution((BatSpec)batSpec), $this.ec, this.batCompiler()).flatMap((Function1 & Serializable & scala.Serializable)result -> {
                                        this.logger().logDebug("*** Sending Results ***");
                                        return this.sendResults((Option<BATTestResult>)result).flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                                            this.logger().logDebug("*** Finishing Pipeline ***");
                                            return this.finalizeRunner().map((Function1 & Serializable & scala.Serializable)_ -> result, $this.ec);
                                        }, $this.ec);
                                    }, $this.ec);
                                }, $this.ec);
                            }, $this.ec);
                        }, $this.ec);
                    }, $this.ec);
                }, $this.ec);
            }, $this.ec);
        }, this.ec);
    }

    public BatPipeline(Execution execution, BatCompiler batCompiler, ExecutionContext ec) {
        this.execution = execution;
        this.batCompiler = batCompiler;
        this.ec = ec;
        WorkerAPI.$init$(this);
    }
}

