@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  bat-cli startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and BAT_CLI_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-Djava.net.preferIPv4Stack=true"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\bat-cli-1.1.11.jar;%APP_HOME%\lib\bat-raml-1.1.11.jar;%APP_HOME%\lib\bat-runner-1.1.8.jar;%APP_HOME%\lib\bdd-core-1.1.7.jar;%APP_HOME%\lib\io-module-2.3.1-BAT.3.jar;%APP_HOME%\lib\core-modules-2.3.1-BAT.3.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.12.3.jar;%APP_HOME%\lib\amf-client_2.12-4.7.6.jar;%APP_HOME%\lib\amf-webapi_2.12-4.7.6.jar;%APP_HOME%\lib\amf-custom-validation_2.12-5.1.8.jar;%APP_HOME%\lib\amf-aml_2.12-5.1.8.jar;%APP_HOME%\lib\amf-validation_2.12-5.1.8.jar;%APP_HOME%\lib\jena-shacl-3.14.0.jar;%APP_HOME%\lib\jena-arq-3.14.0.jar;%APP_HOME%\lib\jackson-databind-2.12.3.jar;%APP_HOME%\lib\jackson-annotations-2.12.3.jar;%APP_HOME%\lib\jackson-core-2.12.3.jar;%APP_HOME%\lib\jackson-module-scala_2.12-2.12.3.jar;%APP_HOME%\lib\scaffeine_2.12-4.0.0.jar;%APP_HOME%\lib\runtime-2.3.1-BAT.3.jar;%APP_HOME%\lib\java-module-2.3.1-BAT.3.jar;%APP_HOME%\lib\yaml-module-2.3.1-BAT.3.jar;%APP_HOME%\lib\core-2.3.1-BAT.3.jar;%APP_HOME%\lib\debugger-2.3.1-BAT.3.jar;%APP_HOME%\lib\parser-2.3.1-BAT.3.jar;%APP_HOME%\lib\amf-core_2.12-4.2.223.jar;%APP_HOME%\lib\scala-java8-compat_2.12-0.9.1.jar;%APP_HOME%\lib\scopt_2.12-3.7.0.jar;%APP_HOME%\lib\spire_2.12-0.14.1.jar;%APP_HOME%\lib\parboiled_2.12-2.1.5.jar;%APP_HOME%\lib\spire-macros_2.12-0.14.1.jar;%APP_HOME%\lib\machinist_2.12-0.6.1.jar;%APP_HOME%\lib\algebra_2.12-0.7.0.jar;%APP_HOME%\lib\shapeless_2.12-2.3.3.jar;%APP_HOME%\lib\syaml_2.12-1.1.305.jar;%APP_HOME%\lib\scala-reflect-2.12.0.jar;%APP_HOME%\lib\cats-kernel_2.12-0.9.0.jar;%APP_HOME%\lib\macro-compat_2.12-1.1.1.jar;%APP_HOME%\lib\scala-common_2.12-1.0.83.jar;%APP_HOME%\lib\json4s-native_2.12-3.5.4.jar;%APP_HOME%\lib\json4s-core_2.12-3.5.4.jar;%APP_HOME%\lib\json4s-ast_2.12-3.5.4.jar;%APP_HOME%\lib\json4s-scalap_2.12-3.5.4.jar;%APP_HOME%\lib\scala-xml_2.12-1.0.6.jar;%APP_HOME%\lib\scala-library-2.12.12.jar;%APP_HOME%\lib\jsonld-java-0.12.5.jar;%APP_HOME%\lib\jena-core-3.14.0.jar;%APP_HOME%\lib\jena-base-3.14.0.jar;%APP_HOME%\lib\commons-io-2.7.jar;%APP_HOME%\lib\httpmime-4.5.13.jar;%APP_HOME%\lib\commons-compress-1.21.jar;%APP_HOME%\lib\commons-beanutils-1.9.4.jar;%APP_HOME%\lib\cron-utils-9.1.5.jar;%APP_HOME%\lib\guava-28.2-jre.jar;%APP_HOME%\lib\libthrift-0.14.1.jar;%APP_HOME%\lib\httpclient-cache-4.5.10.jar;%APP_HOME%\lib\httpclient-4.5.13.jar;%APP_HOME%\lib\commons-codec-1.14.jar;%APP_HOME%\lib\wlang-2.3.1-BAT.3.jar;%APP_HOME%\lib\undertow-core-2.0.33.Final.jar;%APP_HOME%\lib\woodstox-core-5.3.0.jar;%APP_HOME%\lib\aalto-xml-1.0.0.jar;%APP_HOME%\lib\commons-lang3-3.9.jar;%APP_HOME%\lib\jakarta.mail-1.6.4.jar;%APP_HOME%\lib\org.everit.json.schema-1.12.2.jar;%APP_HOME%\lib\commons-validator-1.6.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-collections-3.2.2.jar;%APP_HOME%\lib\jena-shaded-guava-3.14.0.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.26.jar;%APP_HOME%\lib\jena-iri-3.14.0.jar;%APP_HOME%\lib\slf4j-api-1.7.30.jar;%APP_HOME%\lib\javax.el-3.0.0.jar;%APP_HOME%\lib\paranamer-2.8.jar;%APP_HOME%\lib\snakeyaml-1.27.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\caffeine-2.8.1.jar;%APP_HOME%\lib\checker-qual-3.1.0.jar;%APP_HOME%\lib\error_prone_annotations-2.3.4.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\reflections-0.9.12.jar;%APP_HOME%\lib\stax2-api-4.2.jar;%APP_HOME%\lib\jakarta.activation-1.2.1.jar;%APP_HOME%\lib\httpcore-4.4.13.jar;%APP_HOME%\lib\jboss-logging-3.4.0.Final.jar;%APP_HOME%\lib\xnio-nio-3.3.8.Final.jar;%APP_HOME%\lib\xnio-api-3.3.8.Final.jar;%APP_HOME%\lib\json-20201115.jar;%APP_HOME%\lib\javassist-3.26.0-GA.jar;%APP_HOME%\lib\handy-uri-templates-2.1.8.jar;%APP_HOME%\lib\re2j-1.3.jar;%APP_HOME%\lib\commons-digester-1.8.1.jar;%APP_HOME%\lib\joda-time-2.10.2.jar;%APP_HOME%\lib\javax.annotation-api-1.3.2.jar;%APP_HOME%\lib\commons-cli-1.4.jar;%APP_HOME%\lib\commons-csv-1.7.jar;%APP_HOME%\lib\collection-0.7.jar

@rem Execute bat-cli
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %BAT_CLI_OPTS%  -classpath "%CLASSPATH%" com.mulesoft.bat.EntryPoint %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable BAT_CLI_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%BAT_CLI_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
