/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.render;

import java.io.Serializable;
import org.mulesoft.common.core.package;
import org.mulesoft.common.core.package$;
import org.yaml.lexer.YamlCharRules$;
import org.yaml.model.DoubleQuoteMark$;
import org.yaml.model.MultilineMark$;
import org.yaml.model.NoMark$;
import org.yaml.model.ScalarMark;
import org.yaml.model.SingleQuoteMark$;
import org.yaml.model.YType;
import org.yaml.model.YType$;
import org.yaml.parser.ScalarParser;
import org.yaml.parser.ScalarParser$;
import org.yaml.render.ScalarRender;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ScalarRender$ {
    public static ScalarRender$ MODULE$;

    static {
        new ScalarRender$();
    }

    public CharSequence renderScalar(String text, boolean mustBeString, ScalarMark mark, int indentation, String firstLineComment, boolean isCoreSchema) {
        CharSequence charSequence;
        ScalarMark scalarMark = this.analyzeScalar(text, mark, mustBeString, isCoreSchema);
        if (NoMark$.MODULE$.equals(scalarMark)) {
            charSequence = text;
        } else if (DoubleQuoteMark$.MODULE$.equals(scalarMark)) {
            charSequence = new StringBuilder(11).append('\"').append(package.Strings$.MODULE$.encode$extension0(package$.MODULE$.Strings(text))).append('\"').toString();
        } else if (SingleQuoteMark$.MODULE$.equals(scalarMark)) {
            charSequence = new StringBuilder(2).append("'").append(text.replace("\n", "\n\n")).append("'").toString();
        } else if (MultilineMark$.MODULE$.equals(scalarMark)) {
            charSequence = this.renderAsLiteral(text, firstLineComment, indentation);
        } else {
            throw new MatchError((Object)scalarMark);
        }
        return charSequence;
    }

    public boolean renderScalar$default$2() {
        return true;
    }

    public ScalarMark renderScalar$default$3() {
        return NoMark$.MODULE$;
    }

    public int renderScalar$default$4() {
        return 0;
    }

    public String renderScalar$default$5() {
        return "";
    }

    public boolean renderScalar$default$6() {
        return true;
    }

    private CharSequence renderAsLiteral(String text, String firstLineComment, int indentation) {
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
        int ind = indentation < 0 ? 2 : indentation + 2;
        builder.$plus$eq('|');
        int l = text.length();
        Object object = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).head()) == ' ' ? builder.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger((int)ind)).toString()) : BoxedUnit.UNIT;
        Object object2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), l - 1) != '\n' ? builder.$plus$eq('-') : (l > 1 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), l - 2) == '\n' ? builder.$plus$eq('+') : BoxedUnit.UNIT);
        builder.$plus$plus$eq(firstLineComment);
        int start = 0;
        int end = 0;
        do {
            BoxedUnit boxedUnit;
            String str = (end = text.indexOf(10, start)) == -1 ? text.substring(start) : text.substring(start, end);
            builder.$plus$eq('\n');
            if (new StringOps(Predef$.MODULE$.augmentString(str)).nonEmpty()) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ind).foreach((Function1 & Serializable & scala.Serializable)_ -> builder.$plus$eq(' '));
                boxedUnit = builder.$plus$plus$eq(str);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            start = end + 1;
        } while (end != -1);
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ScalarMark analyzeScalar(String text, ScalarMark mark, boolean mustBeString, boolean isCoreSchema) {
        ScalarMark scalarMark;
        boolean allSpaces;
        block22: {
            block23: {
                block25: {
                    block24: {
                        ScalarMark scalarMark2 = mark;
                        DoubleQuoteMark$ doubleQuoteMark$ = DoubleQuoteMark$.MODULE$;
                        if (scalarMark2 == null) {
                            if (doubleQuoteMark$ == null) return mark;
                        } else if (scalarMark2.equals(doubleQuoteMark$)) return mark;
                        ScalarMark scalarMark3 = mark;
                        SingleQuoteMark$ singleQuoteMark$ = SingleQuoteMark$.MODULE$;
                        if (scalarMark3 == null) {
                            if (singleQuoteMark$ == null) return mark;
                        } else if (scalarMark3.equals(singleQuoteMark$)) {
                            return mark;
                        }
                        int l = text.length();
                        if (l == 0) {
                            ScalarMark scalarMark4;
                            if (!mustBeString && mark.plain()) {
                                scalarMark4 = NoMark$.MODULE$;
                                return scalarMark4;
                            }
                            scalarMark4 = DoubleQuoteMark$.MODULE$;
                            return scalarMark4;
                        }
                        if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).head()) == ' ') return DoubleQuoteMark$.MODULE$;
                        if (text.endsWith("\n\n")) {
                            return DoubleQuoteMark$.MODULE$;
                        }
                        boolean oneLine = true;
                        allSpaces = true;
                        boolean noTabs = true;
                        boolean flowChar = false;
                        ScalarRender.ScalarIterator iterator = new ScalarRender.ScalarIterator(text);
                        do {
                            char c = iterator.current();
                            switch (c) {
                                case '\n': {
                                    oneLine = false;
                                    break;
                                }
                                case '\t': {
                                    noTabs = false;
                                    break;
                                }
                                case '\r': {
                                    return DoubleQuoteMark$.MODULE$;
                                }
                                default: {
                                    if (!YamlCharRules$.MODULE$.isCPrintable(iterator.current())) {
                                        return DoubleQuoteMark$.MODULE$;
                                    }
                                    if (iterator.shouldQuote()) {
                                        flowChar = true;
                                        break;
                                    }
                                    allSpaces = false;
                                    break;
                                }
                            }
                        } while (iterator.advance());
                        if (!oneLine) break block22;
                        if (flowChar) {
                            scalarMark = DoubleQuoteMark$.MODULE$;
                            return scalarMark;
                        }
                        if (!mark.plain() || !noTabs || BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(text)).last()) == ' ') break block23;
                        if (!mustBeString) {
                            scalarMark = NoMark$.MODULE$;
                            return scalarMark;
                        }
                        ScalarParser sp2 = ScalarParser$.MODULE$.apply(text);
                        sp2.parse();
                        YType yType = sp2.yType();
                        YType yType2 = YType$.MODULE$.Str();
                        if (!(yType == null ? yType2 != null : !yType.equals(yType2))) break block24;
                        if (!isCoreSchema) break block25;
                        YType yType3 = sp2.yType();
                        YType yType4 = YType$.MODULE$.Timestamp();
                        if (yType3 != null ? !yType3.equals(yType4) : yType4 != null) break block25;
                    }
                    scalarMark = NoMark$.MODULE$;
                    return scalarMark;
                }
                scalarMark = DoubleQuoteMark$.MODULE$;
                return scalarMark;
            }
            scalarMark = DoubleQuoteMark$.MODULE$;
            return scalarMark;
        }
        if (allSpaces) {
            scalarMark = DoubleQuoteMark$.MODULE$;
            return scalarMark;
        }
        scalarMark = MultilineMark$.MODULE$;
        return scalarMark;
    }

    public boolean analyzeScalar$default$4() {
        return true;
    }

    private ScalarRender$() {
        MODULE$ = this;
    }
}

