/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.xnio.FileSystemWatcher;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.management.XnioProviderMXBean;
import org.xnio.management.XnioServerMXBean;
import org.xnio.management.XnioWorkerMXBean;
import org.xnio.nio.Log;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.Version;
import org.xnio.nio.WatchServiceFileSystemWatcher;

final class NioXnio
extends Xnio {
    final SelectorCreator tempSelectorCreator;
    final SelectorCreator mainSelectorCreator;
    private final ThreadLocal<FinalizableSelectorHolder> selectorThreadLocal = new ThreadLocal<FinalizableSelectorHolder>(){

        @Override
        public void remove() {
            FinalizableSelectorHolder holder = (FinalizableSelectorHolder)this.get();
            if (holder != null) {
                IoUtils.safeClose((Selector)holder.selector);
            }
            super.remove();
        }
    };

    NioXnio() {
        super("nio");
        Object[] objects = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                ConstructorSelectorCreator creator2;
                SelectorProvider defaultProvider = SelectorProvider.provider();
                String chosenProvider = System.getProperty("xnio.nio.selector.provider");
                SelectorProvider provider = null;
                if (chosenProvider != null) {
                    try {
                        provider = Class.forName(chosenProvider, true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        provider = null;
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.KQueueSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        provider = null;
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.EPollSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        provider = null;
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.DevPollSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        provider = null;
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.PollsetSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        provider = null;
                    }
                }
                if (provider == null) {
                    try {
                        defaultProvider.openSelector().close();
                        provider = defaultProvider;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (provider == null) {
                    try {
                        provider = Class.forName("sun.nio.ch.PollSelectorProvider", true, NioXnio.class.getClassLoader()).asSubclass(SelectorProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                        provider.openSelector().close();
                    }
                    catch (Throwable e) {
                        provider = null;
                    }
                }
                if (provider == null) {
                    throw Log.log.noSelectorProvider();
                }
                Log.log.selectorProvider(provider);
                boolean defaultIsPoll = "sun.nio.ch.PollSelectorProvider".equals(provider.getClass().getName());
                String chosenMainSelector = System.getProperty("xnio.nio.selector.main");
                String chosenTempSelector = System.getProperty("xnio.nio.selector.temp");
                DefaultSelectorCreator defaultSelectorCreator = new DefaultSelectorCreator(provider);
                Object[] objects = new Object[3];
                objects[0] = provider;
                if (chosenTempSelector != null) {
                    try {
                        creator2 = new ConstructorSelectorCreator(chosenTempSelector, provider);
                        IoUtils.safeClose((Selector)creator2.open());
                        objects[1] = creator2;
                    }
                    catch (Exception creator2) {
                        // empty catch block
                    }
                }
                if (chosenMainSelector != null) {
                    try {
                        creator2 = new ConstructorSelectorCreator(chosenMainSelector, provider);
                        IoUtils.safeClose((Selector)creator2.open());
                        objects[2] = creator2;
                    }
                    catch (Exception creator3) {
                        // empty catch block
                    }
                }
                if (!defaultIsPoll && objects[1] == null) {
                    try {
                        creator2 = new ConstructorSelectorCreator("sun.nio.ch.PollSelectorImpl", provider);
                        IoUtils.safeClose((Selector)creator2.open());
                        objects[1] = creator2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (objects[1] == null) {
                    objects[1] = defaultSelectorCreator;
                }
                if (objects[2] == null) {
                    objects[2] = defaultSelectorCreator;
                }
                return objects;
            }
        });
        this.tempSelectorCreator = (SelectorCreator)objects[1];
        this.mainSelectorCreator = (SelectorCreator)objects[2];
        Log.log.selectors(this.mainSelectorCreator, this.tempSelectorCreator);
        NioXnio.register((XnioProviderMXBean)new XnioProviderMXBean(){

            public String getName() {
                return "nio";
            }

            public String getVersion() {
                return Version.getVersionString();
            }
        });
    }

    public XnioWorker createWorker(ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException, IllegalArgumentException {
        NioXnioWorker worker = new NioXnioWorker(this, threadGroup, optionMap, terminationTask);
        worker.start();
        return worker;
    }

    public FileSystemWatcher createFileSystemWatcher(String name, OptionMap options) {
        try {
            boolean daemonThread = options.get(Options.THREAD_DAEMON, true);
            return new WatchServiceFileSystemWatcher(name, daemonThread);
        }
        catch (LinkageError linkageError) {
            return super.createFileSystemWatcher(name, options);
        }
    }

    Selector getSelector() throws IOException {
        ThreadLocal<FinalizableSelectorHolder> threadLocal = this.selectorThreadLocal;
        FinalizableSelectorHolder holder = threadLocal.get();
        if (holder == null) {
            holder = new FinalizableSelectorHolder(this.tempSelectorCreator.open());
            threadLocal.set(holder);
        }
        return holder.selector;
    }

    protected static Closeable register(XnioWorkerMXBean workerMXBean) {
        return Xnio.register((XnioWorkerMXBean)workerMXBean);
    }

    protected static Closeable register(XnioServerMXBean serverMXBean) {
        return Xnio.register((XnioServerMXBean)serverMXBean);
    }

    static {
        Log.log.greeting(Version.getVersionString());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String bugLevel = System.getProperty("sun.nio.ch.bugLevel");
                if (bugLevel == null) {
                    System.setProperty("sun.nio.ch.bugLevel", "");
                }
                return null;
            }
        });
    }

    private static final class FinalizableSelectorHolder {
        final Selector selector;

        private FinalizableSelectorHolder(Selector selector) {
            this.selector = selector;
        }

        protected void finalize() throws Throwable {
            IoUtils.safeClose((Selector)this.selector);
        }
    }

    private static class ConstructorSelectorCreator
    implements SelectorCreator {
        private final Constructor<? extends Selector> constructor;
        private final SelectorProvider provider;

        public ConstructorSelectorCreator(String name, SelectorProvider provider) throws ClassNotFoundException, NoSuchMethodException {
            this.provider = provider;
            Class<Selector> selectorImplClass = Class.forName(name, true, null).asSubclass(Selector.class);
            Constructor<Selector> constructor = selectorImplClass.getDeclaredConstructor(SelectorProvider.class);
            constructor.setAccessible(true);
            this.constructor = constructor;
        }

        @Override
        public Selector open() throws IOException {
            try {
                return this.constructor.newInstance(this.provider);
            }
            catch (InstantiationException e) {
                return Selector.open();
            }
            catch (IllegalAccessException e) {
                return Selector.open();
            }
            catch (InvocationTargetException e) {
                try {
                    throw e.getTargetException();
                }
                catch (IOException | Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable t) {
                    throw Log.log.unexpectedSelectorOpenProblem(t);
                }
            }
        }

        public String toString() {
            return String.format("Selector creator %s for provider %s", this.constructor.getDeclaringClass(), this.provider.getClass());
        }
    }

    private static class DefaultSelectorCreator
    implements SelectorCreator {
        private final SelectorProvider provider;

        private DefaultSelectorCreator(SelectorProvider provider) {
            this.provider = provider;
        }

        @Override
        public Selector open() throws IOException {
            return this.provider.openSelector();
        }

        public String toString() {
            return "Default system selector creator for provider " + this.provider.getClass();
        }
    }

    static interface SelectorCreator {
        public Selector open() throws IOException;
    }
}

