/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_DataTuple;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_VAR;
import org.apache.jena.riot.thrift.wire.RDF_VarTuple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class Binding2Thrift
implements AutoCloseable {
    private final RDF_DataTuple row = new RDF_DataTuple();
    private final Collection<Var> vars;
    private final OutputStream out;
    private final TProtocol protocol;
    private final boolean encodeValues;

    public Binding2Thrift(OutputStream out, Collection<Var> vars, boolean encodeValues) {
        this.out = out;
        this.vars = vars;
        TIOStreamTransport transport = new TIOStreamTransport(out);
        this.protocol = TRDF.protocol((TTransport)transport);
        this.encodeValues = encodeValues;
        this.varsRow();
    }

    private void varsRow() {
        RDF_VarTuple vrow = new RDF_VarTuple(new ArrayList<RDF_VAR>(this.vars.size()));
        for (Var v : this.vars) {
            RDF_VAR rv = new RDF_VAR();
            rv.setName(v.getName());
            vrow.addToVars(rv);
        }
        try {
            vrow.write(this.protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
    }

    public Binding2Thrift(TProtocol out, Collection<Var> vars, boolean encodeValues) {
        this.vars = vars;
        this.out = null;
        this.protocol = out;
        this.encodeValues = encodeValues;
        this.varsRow();
    }

    public void output(Binding binding) {
        Iterator<Var> vIter;
        Iterator<Var> iterator = vIter = this.vars == null ? null : this.vars.iterator();
        if (vIter == null) {
            vIter = binding.vars();
        }
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node n = binding.get(v);
            RDF_Term rt = n == null ? TRDF.tUNDEF : ThriftConvert.convert(n, this.encodeValues);
            this.row.addToRow(rt);
        }
        try {
            this.row.write(this.protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
        this.row.clear();
    }

    @Override
    public void close() {
        TRDF.flush(this.protocol);
    }
}

