/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.AlgebraGenerator;
import org.apache.jena.sparql.algebra.AlgebraQuad;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformUnionQuery;
import org.apache.jena.sparql.algebra.optimize.Optimize;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.engine.ref.QueryEngineRef;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderOp;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.Context;

public class Algebra {
    public static Op optimize(Op op) {
        return Algebra.optimize(op, null);
    }

    public static Op optimize(Op op, Context context2) {
        if (context2 == null) {
            context2 = ARQ.getContext();
        }
        if (op == null) {
            return null;
        }
        return Optimize.optimize(op, context2);
    }

    public static Op compile(Query query) {
        if (query == null) {
            return null;
        }
        return new AlgebraGenerator().compile(query);
    }

    public static Op compile(Element elt) {
        if (elt == null) {
            return null;
        }
        return new AlgebraGenerator().compile(elt);
    }

    public static Op toQuadForm(Op op) {
        return AlgebraQuad.quadize(op);
    }

    public static Op toQuadBlockForm(Op op) {
        return AlgebraQuad.quadizeBlock(op);
    }

    public static Op unionDefaultGraph(Op op) {
        return TransformUnionQuery.transform(op);
    }

    public static Op read(String filename) {
        Item item = SSE.readFile(filename);
        return Algebra.parse(item);
    }

    public static Op parse(String string) {
        Item item = SSE.parse(string);
        return Algebra.parse(item);
    }

    public static Op parse(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return Algebra.parse(item);
    }

    public static Op parse(Item item) {
        Op op = BuilderOp.build(item);
        return op;
    }

    public static QueryIterator exec(Op op, Dataset ds) {
        return Algebra.exec(op, ds.asDatasetGraph());
    }

    public static QueryIterator exec(Op op, Model model) {
        return Algebra.exec(op, model.getGraph());
    }

    public static QueryIterator exec(Op op, Graph graph) {
        return Algebra.exec(op, DatasetGraphFactory.wrap(graph));
    }

    public static QueryIterator exec(Op op, DatasetGraph ds) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(op, ds, null);
        Plan plan = f.create(op, ds, BindingRoot.create(), null);
        return plan.iterator();
    }

    public static QueryIterator execRef(Op op, Dataset ds) {
        return Algebra.execRef(op, ds.asDatasetGraph());
    }

    public static QueryIterator execRef(Op op, Model model) {
        return Algebra.execRef(op, model.getGraph());
    }

    public static QueryIterator execRef(Op op, Graph graph) {
        return Algebra.execRef(op, DatasetGraphFactory.wrap(graph));
    }

    public static QueryIterator execRef(Op op, DatasetGraph dsg) {
        QueryEngineRef qe = new QueryEngineRef(op, dsg, ARQ.getContext().copy());
        return qe.getPlan().iterator();
    }

    public static Binding merge(Binding bindingLeft, Binding bindingRight) {
        boolean matches = Algebra.compatible(bindingLeft, bindingRight);
        if (!matches) {
            return null;
        }
        BindingMap b = BindingFactory.create(bindingLeft);
        Iterator<Var> vIter = bindingRight.vars();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node n = bindingRight.get(v);
            if (bindingLeft.contains(v)) continue;
            b.add(v, n);
        }
        return b;
    }

    public static boolean compatible(Binding bindingLeft, Binding bindingRight) {
        Iterator<Var> vIter = bindingLeft.vars();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node nLeft = bindingLeft.get(v);
            Node nRight = bindingRight.get(v);
            if (nRight == null || nRight.equals((Object)nLeft)) continue;
            return false;
        }
        return true;
    }

    public static boolean disjoint(Binding binding1, Binding binding2) {
        Iterator<Var> iterVar1 = binding1.vars();
        while (iterVar1.hasNext()) {
            Var v = iterVar1.next();
            if (!binding2.contains(v)) continue;
            return false;
        }
        return true;
    }
}

