/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpService
extends Op1 {
    private final Node serviceNode;
    private final ElementService serviceElement;
    private final boolean silent;

    public OpService(Node serviceNode, Op subOp, boolean silent) {
        this(serviceNode, subOp, null, silent);
    }

    public OpService(Node serviceNode, Op subOp, ElementService elt, boolean silent) {
        super(subOp);
        this.serviceNode = serviceNode;
        this.serviceElement = elt;
        this.silent = silent;
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public Op1 copy(Op newOp) {
        return new OpService(this.serviceNode, newOp, this.silent);
    }

    @Override
    public String getName() {
        return "service";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Node getService() {
        return this.serviceNode;
    }

    public ElementService getServiceElement() {
        return this.serviceElement;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Override
    public int hashCode() {
        return this.serviceNode.hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpService)) {
            return false;
        }
        OpService opService = (OpService)other;
        if (!this.serviceNode.equals((Object)opService.serviceNode)) {
            return false;
        }
        if (opService.getSilent() != this.getSilent()) {
            return false;
        }
        return this.getSubOp().equalTo(opService.getSubOp(), labelMap);
    }
}

