/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.serializer.FormatterBase;
import org.apache.jena.sparql.serializer.FormatterTemplate;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.syntax.Template;

public class FmtTemplate
extends FormatterBase
implements FormatterTemplate {
    static final int INDENT = 2;

    public FmtTemplate(IndentedWriter out, SerializationContext context2) {
        super(out, context2);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Template template) {
        FmtTemplate fmt = new FmtTemplate(out, cxt);
        fmt.startVisit();
        fmt.format(template);
        fmt.finishVisit();
    }

    public static String asString(Template template) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FmtTemplate.format((IndentedWriter)b, cxt, template);
        return b.toString();
    }

    @Override
    public void format(Template template) {
        this.out.print("{");
        this.out.incIndent(2);
        this.out.pad();
        List<Quad> quads = template.getQuads();
        for (Quad quad : quads) {
            BasicPattern bgp = new BasicPattern();
            bgp.add(quad.asTriple());
            this.out.newline();
            if (!Quad.defaultGraphNodeGenerated.equals((Object)quad.getGraph())) {
                this.out.print("GRAPH");
                this.out.print(" ");
                this.out.print(this.slotToString(quad.getGraph()));
                this.out.print(" ");
                this.out.newline();
                this.out.incIndent(2);
                this.out.pad();
                this.out.print("{");
                this.out.incIndent(2);
                this.out.pad();
            }
            this.formatTriples(bgp);
            if (Quad.defaultGraphNodeGenerated.equals((Object)quad.getGraph())) continue;
            this.out.decIndent(2);
            this.out.print("}");
            this.out.decIndent(2);
        }
        this.out.newline();
        this.out.decIndent(2);
        this.out.print("}");
        this.out.newline();
    }
}

