/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LearningPushHandler
implements HttpHandler {
    private static final String SESSION_ATTRIBUTE = "io.undertow.PUSHED_RESOURCES";
    private static final int DEFAULT_MAX_CACHE_ENTRIES = 1000;
    private static final int DEFAULT_MAX_CACHE_AGE = -1;
    private final LRUCache<String, Map<String, PushedRequest>> cache;
    private final HttpHandler next;

    public LearningPushHandler(HttpHandler next) {
        this(1000, -1, next);
    }

    public LearningPushHandler(int maxEntries, int maxAge, HttpHandler next) {
        this.next = next;
        this.cache = new LRUCache(maxEntries, maxAge);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String accept;
        String requestPath;
        String fullPath;
        if (exchange.getQueryString().isEmpty()) {
            fullPath = exchange.getRequestURL();
            requestPath = exchange.getRequestPath();
        } else {
            fullPath = exchange.getRequestURL() + "?" + exchange.getQueryString();
            requestPath = exchange.getRequestPath() + "?" + exchange.getQueryString();
        }
        this.doPush(exchange, fullPath);
        String referrer = exchange.getRequestHeaders().getFirst(Headers.REFERER);
        if (!(referrer == null || (accept = exchange.getRequestHeaders().getFirst(Headers.ACCEPT)) != null && accept.contains("text/html"))) {
            exchange.addExchangeCompleteListener(new PushCompletionListener(fullPath, requestPath, referrer));
        }
        this.next.handleRequest(exchange);
    }

    private void doPush(HttpServerExchange exchange, String fullPath) {
        Map<String, PushedRequest> toPush;
        if (exchange.getConnection().isPushSupported() && (toPush = this.cache.get(fullPath)) != null) {
            Session session = this.getSession(exchange);
            if (session == null) {
                return;
            }
            Map<String, Object> pushed = (Map<String, Object>)session.getAttribute(SESSION_ATTRIBUTE);
            if (pushed == null) {
                pushed = Collections.synchronizedMap(new HashMap());
            }
            for (Map.Entry<String, PushedRequest> entry : toPush.entrySet()) {
                boolean doPush;
                PushedRequest request = entry.getValue();
                Object pushedKey = pushed.get(request.getPath());
                boolean bl = doPush = pushedKey == null;
                if (!doPush) {
                    if (pushedKey instanceof String && !pushedKey.equals(request.getEtag())) {
                        doPush = true;
                    } else if (pushedKey instanceof Long && ((Long)pushedKey).longValue() != request.getLastModified()) {
                        doPush = true;
                    }
                }
                if (!doPush) continue;
                exchange.getConnection().pushResource(request.getPath(), Methods.GET, request.getRequestHeaders());
                if (request.getEtag() != null) {
                    pushed.put(request.getPath(), request.getEtag());
                    continue;
                }
                pushed.put(request.getPath(), request.getLastModified());
            }
            session.setAttribute(SESSION_ATTRIBUTE, pushed);
        }
    }

    protected Session getSession(HttpServerExchange exchange) {
        SessionConfig sc = exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
        SessionManager sm = exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
        if (sc == null || sm == null) {
            return null;
        }
        Session session = sm.getSession(exchange, sc);
        if (session == null) {
            return sm.createSession(exchange, sc);
        }
        return session;
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "learning-push";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("max-age", Integer.class);
            params.put("max-entries", Integer.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return null;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            final int maxAge = config.containsKey("max-age") ? (Integer)config.get("max-age") : -1;
            final int maxEntries = config.containsKey("max-entries") ? (Integer)config.get("max-entries") : 1000;
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new LearningPushHandler(maxEntries, maxAge, handler);
                }
            };
        }
    }

    private static class PushedRequest {
        private final HeaderMap requestHeaders;
        private final String path;
        private final String etag;
        private final long lastModified;

        private PushedRequest(HeaderMap requestHeaders, String path, String etag, long lastModified) {
            this.requestHeaders = requestHeaders;
            this.path = path;
            this.etag = etag;
            this.lastModified = lastModified;
        }

        public HeaderMap getRequestHeaders() {
            return this.requestHeaders;
        }

        public String getPath() {
            return this.path;
        }

        public String getEtag() {
            return this.etag;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }

    private final class PushCompletionListener
    implements ExchangeCompletionListener {
        private final String fullPath;
        private final String requestPath;
        private final String referer;

        private PushCompletionListener(String fullPath, String requestPath, String referer) {
            this.fullPath = fullPath;
            this.requestPath = requestPath;
            this.referer = referer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            if (exchange.getStatusCode() == 200 && this.referer != null) {
                Map<String, PushedRequest> pushes;
                Date dt;
                String lmString = exchange.getResponseHeaders().getFirst(Headers.LAST_MODIFIED);
                String etag = exchange.getResponseHeaders().getFirst(Headers.ETAG);
                long lastModified = -1L;
                if (lmString != null && (dt = DateUtils.parseDate(lmString)) != null) {
                    lastModified = dt.getTime();
                }
                if ((pushes = (Map<String, PushedRequest>)LearningPushHandler.this.cache.get(this.referer)) == null) {
                    LRUCache lRUCache = LearningPushHandler.this.cache;
                    synchronized (lRUCache) {
                        pushes = (Map)LearningPushHandler.this.cache.get(this.referer);
                        if (pushes == null) {
                            pushes = Collections.synchronizedMap(new HashMap());
                            LearningPushHandler.this.cache.add(this.referer, pushes);
                        }
                    }
                }
                pushes.put(this.fullPath, new PushedRequest(new HeaderMap(), this.requestPath, etag, lastModified));
            }
            nextListener.proceed();
        }
    }
}

