/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintEntity;
import org.apache.jena.shacl.validation.ReportItem;

public abstract class CardinalityConstraint
extends ConstraintEntity {
    protected final int minCount;
    protected final int maxCount;

    protected CardinalityConstraint(int minCardinality, int maxCardinality) {
        this.minCount = minCardinality;
        this.maxCount = maxCardinality;
    }

    protected static String strInt(int x) {
        return x < 0 ? "_" : Integer.toString(x);
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Set<Node> nodes) {
        int count = nodes.size();
        if (this.minCount >= 0 && count < this.minCount) {
            String msg = this.toString() + ": Invalid cardinality: expected min " + this.minCount + ": Got count = " + count;
            return new ReportItem(msg);
        }
        if (this.maxCount >= 0 && count > this.maxCount) {
            String msg = this.toString() + ": Invalid cardinality: expected max " + this.maxCount + ": Got count = " + count;
            return new ReportItem(msg);
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.maxCount, this.minCount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CardinalityConstraint other = (CardinalityConstraint)obj;
        return this.maxCount == other.maxCount && this.minCount == other.minCount;
    }
}

