/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintPairwise;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class DisjointConstraint
extends ConstraintPairwise {
    public DisjointConstraint(Node property) {
        super(property);
    }

    @Override
    public void validate(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Set<Node> compareNodes) {
        for (Node vn : pathNodes) {
            if (!compareNodes.contains(vn)) continue;
            String msg = this.toString() + ": not disjoint: " + ShLib.displayStr(vn) + " is in " + compareNodes;
            vCxt.reportEntry(msg, shape, focusNode, path, vn, this);
        }
    }

    @Override
    public Node getComponent() {
        return SHACL.DisjointConstraintComponent;
    }

    public String toString() {
        return "Disjoint[" + ShLib.displayStr(this.property) + "]";
    }
}

