/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.json.reader.indexed;

import java.io.Serializable;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.common.LocationCacheBuilder;
import org.mule.weave.v2.module.json.reader.JsonTokenizer;
import org.mule.weave.v2.module.json.reader.indexed.JsonLocation;
import org.mule.weave.v2.module.json.reader.indexed.JsonRootValue$;
import org.mule.weave.v2.module.json.reader.indexed.JsonTokenHelper$;
import org.mule.weave.v2.module.json.reader.indexed.JsonTokenType$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.indexed.LocationCaches;
import org.mule.weave.v2.module.xml.reader.indexed.TokenArray;
import org.mule.weave.v2.module.xml.reader.indexed.TokenArray$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0010!\u0001EB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005}!A!\n\u0001BC\u0002\u0013\u00053\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0011\u0006A!A!\u0002\u0017\u0019\u0006\"B-\u0001\t\u0003Q\u0006bB1\u0001\u0001\u0004%IA\u0019\u0005\bM\u0002\u0001\r\u0011\"\u0003h\u0011\u0019i\u0007\u0001)Q\u0005G\"9a\u000e\u0001b\u0001\n\u0013y\u0007B\u0002=\u0001A\u0003%\u0001\u000fC\u0004z\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\r\u0001\u0001)A\u0005w\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003[\u0001A\u0011CA\u0018\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBA=\u0001\u0011%\u0011q\u000f\u0005\b\u0003w\u0002A\u0011BA<\u0011\u001d\ti\b\u0001C\u0005\u0003oBq!a \u0001\t+\t9\bC\u0004\u0002\u0010\u0002!\t\"!%\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u001d\u0001\u0005\n\u0005]\u0004bBAt\u0001\u0011%\u0011q\u000f\u0005\b\u0003W\u0004A\u0011BA<\u0005QIe\u000eZ3yK\u0012T5o\u001c8U_.,g.\u001b>fe*\u0011\u0011EI\u0001\bS:$W\r_3e\u0015\t\u0019C%\u0001\u0004sK\u0006$WM\u001d\u0006\u0003K\u0019\nAA[:p]*\u0011q\u0005K\u0001\u0007[>$W\u000f\\3\u000b\u0005%R\u0013A\u0001<3\u0015\tYC&A\u0003xK\u00064XM\u0003\u0002.]\u0005!Q.\u001e7f\u0015\u0005y\u0013aA8sO\u000e\u00011c\u0001\u00013qA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\u0004\"!\u000f\u001e\u000e\u0003\tJ!a\u000f\u0012\u0003\u001b)\u001bxN\u001c+pW\u0016t\u0017N_3s\u0003\u0011q\u0017-\\3\u0016\u0003y\u0002\"a\u0010$\u000f\u0005\u0001#\u0005CA!5\u001b\u0005\u0011%BA\"1\u0003\u0019a$o\\8u}%\u0011Q\tN\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002Fi\u0005)a.Y7fA\u0005)\u0011N\u001c9viV\tA\n\u0005\u0002N\u001f6\taJ\u0003\u0002$M%\u0011\u0001K\u0014\u0002\r'>,(oY3SK\u0006$WM]\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\u0007\r$\b\u0010\u0005\u0002U/6\tQK\u0003\u0002WQ\u0005)Qn\u001c3fY&\u0011\u0001,\u0016\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002\\?\u0002$\"\u0001\u00180\u0011\u0005u\u0003Q\"\u0001\u0011\t\u000bI3\u00019A*\t\u000bq2\u0001\u0019\u0001 \t\u000b)3\u0001\u0019\u0001'\u0002\u000b\u0011,\u0007\u000f\u001e5\u0016\u0003\r\u0004\"a\r3\n\u0005\u0015$$aA%oi\u0006IA-\u001a9uQ~#S-\u001d\u000b\u0003Q.\u0004\"aM5\n\u0005)$$\u0001B+oSRDq\u0001\u001c\u0005\u0002\u0002\u0003\u00071-A\u0002yIE\na\u0001Z3qi\"\u0004\u0013a\u0003;pW\u0016t')\u001e4gKJ,\u0012\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003CMT!a\t;\u000b\u0005U4\u0013a\u0001=nY&\u0011qO\u001d\u0002\u000b)>\\WM\\!se\u0006L\u0018\u0001\u0004;pW\u0016t')\u001e4gKJ\u0004\u0013!\u00037d\u0005VLG\u000eZ3s+\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@'\u0003\u0019\u0019w.\\7p]&\u0019\u0011\u0011A?\u0003)1{7-\u0019;j_:\u001c\u0015m\u00195f\u0005VLG\u000eZ3s\u0003)a7MQ;jY\u0012,'\u000fI\u0001\tC\u0012$Gk\\6f]R)\u0001.!\u0003\u0002\u001a!9\u00111\u0002\bA\u0002\u00055\u0011!\u0002;pW\u0016t\u0007#B\u001a\u0002\u0010\u0005M\u0011bAA\ti\t)\u0011I\u001d:bsB\u00191'!\u0006\n\u0007\u0005]AG\u0001\u0003M_:<\u0007bBA\u000e\u001d\u0001\u0007\u0011QD\u0001\raV$Hk\\6f]&sGj\u0011\t\u0004g\u0005}\u0011bAA\u0011i\t9!i\\8mK\u0006t\u0017!\u0005:fC\u0012\u001cFO]5oO\u000e{g\u000e^3oiR\u0011\u0011q\u0005\t\bg\u0005%\u00121C2?\u0013\r\tY\u0003\u000e\u0002\u0007)V\u0004H.Z\u001a\u0002\u0015I,\u0017\rZ*ue&tw\r\u0006\u0002\u00022A11'a\r\u0002\u0014\rL1!!\u000e5\u0005\u0019!V\u000f\u001d7fe\u00051Ao\\6f]N,\"!a\u000f\u0011\rM\n\u0019\u0004]A\u001f!\r\t\u0018qH\u0005\u0004\u0003\u0003\u0012(A\u0004'pG\u0006$\u0018n\u001c8DC\u000eDWm]\u0001\u0006a\u0006\u00148/Z\u000b\u0003\u0003\u000f\u0002D!!\u0013\u0002ZA1\u00111JA)\u0003+j!!!\u0014\u000b\u0007\u0005=S+\u0001\u0004wC2,Xm]\u0005\u0005\u0003'\niEA\u0003WC2,X\r\u0005\u0003\u0002X\u0005eC\u0002\u0001\u0003\f\u00037\u0012\u0012\u0011!A\u0001\u0006\u0003\tiFA\u0002`IE\nB!a\u0018\u0002fA\u00191'!\u0019\n\u0007\u0005\rDGA\u0004O_RD\u0017N\\4\u0011\u0007M\n9'C\u0002\u0002jQ\u00121!\u00118z\u0003%\u0011X-\u00193WC2,X\rF\u0002i\u0003_Bq!a\u0007\u0014\u0001\u0004\ti\"\u0001\u0006sK\u0006$g*^7cKJ$\u0012aY\u0001\be\u0016\fG-\u00138u)\u0005A\u0017\u0001\u0003:fC\u00124%/Y2\u0002\u000fI,\u0017\rZ#ya\u0006\u0019\"/Z1e\u001f:,wJ]'pe\u0016$\u0015nZ5ug\u0006!\"/Z1e5\u0016\u0014xn\u0014:N_J,G)[4jiND3!GAB!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAEi\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u0015q\u0011\u0002\bi\u0006LGN]3d\u0003%\u0011X-\u00193ES\u001eLG\u000f\u0006\u0002\u0002\u001e\u0005)\u0011N\u001c8feRi\u0001.a&\u0002\u001c\u00065\u0017\u0011[Am\u0003GDq!!'\u001c\u0001\u0004\t\u0019\"\u0001\u0002bi\"9\u0011QT\u000eA\u0002\u0005}\u0015!B:uCJ$\b\u0003BAQ\u0003\u000ftA!a)\u0002D:!\u0011QUAa\u001d\u0011\t9+a0\u000f\t\u0005%\u0016Q\u0018\b\u0005\u0003W\u000bYL\u0004\u0003\u0002.\u0006ef\u0002BAX\u0003osA!!-\u00026:\u0019\u0011)a-\n\u0003=J!!\f\u0018\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%\u00111\u0005J\u0005\u0003C\tJ1!!2!\u00035Q5o\u001c8U_.,g\u000eV=qK&!\u0011\u0011ZAf\u00055Q5o\u001c8U_.,g\u000eV=qK*\u0019\u0011Q\u0019\u0011\t\u000f\u0005=7\u00041\u0001\u0002 \u0006\u0019QM\u001c3\t\u000f\u0005M5\u00041\u0001\u0002TB!1'!6i\u0013\r\t9\u000e\u000e\u0002\n\rVt7\r^5p]BBq!a7\u001c\u0001\u0004\ti.A\u0002sKF\u00042aMAp\u0013\r\t\t\u000f\u000e\u0002\u0005\u0007\"\f'\u000fC\u0004\u0002\u001cm\u0001\r!!\b\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG/A\tsK\u0006$wJ\u00196fGRlU-\u001c2feND3!HAB\u0003%\u0011X-\u00193BeJ\f\u0017\u0010")
public class IndexedJsonTokenizer
implements JsonTokenizer {
    private final String name;
    private final SourceReader input;
    private final EvaluationContext ctx;
    private int depth;
    private final TokenArray tokenBuffer;
    private final LocationCacheBuilder lcBuilder;
    private long cursorCharLocation;
    private char cursorChar;
    private final char[] strBuffer;

    @Override
    public char currentChar() {
        return JsonTokenizer.currentChar$(this);
    }

    @Override
    public JsonLocation location() {
        return JsonTokenizer.location$(this);
    }

    @Override
    public String parseString() {
        return JsonTokenizer.parseString$(this);
    }

    @Override
    public boolean readChar() {
        return JsonTokenizer.readChar$(this);
    }

    @Override
    public void readEscapedChar(Option<scala.collection.mutable.StringBuilder> target) {
        JsonTokenizer.readEscapedChar$(this, target);
    }

    @Override
    public Option<scala.collection.mutable.StringBuilder> readEscapedChar$default$1() {
        return JsonTokenizer.readEscapedChar$default$1$(this);
    }

    @Override
    public void eof() {
        JsonTokenizer.eof$(this);
    }

    @Override
    public void requireFalse() {
        JsonTokenizer.requireFalse$(this);
    }

    @Override
    public void requireNull() {
        JsonTokenizer.requireNull$(this);
    }

    @Override
    public void requireTrue() {
        JsonTokenizer.requireTrue$(this);
    }

    @Override
    public boolean advance() {
        return JsonTokenizer.advance$(this);
    }

    @Override
    public boolean advanceChar() {
        return JsonTokenizer.advanceChar$(this);
    }

    @Override
    public boolean ws(char c) {
        return JsonTokenizer.ws$(this, c);
    }

    @Override
    public final void ws() {
        JsonTokenizer.ws$(this);
    }

    @Override
    public boolean advanceIf(char c) {
        return JsonTokenizer.advanceIf$(this, c);
    }

    @Override
    public void require(char c) {
        JsonTokenizer.require$(this, c);
    }

    @Override
    public boolean advanceCharIf(char c) {
        return JsonTokenizer.advanceCharIf$(this, c);
    }

    @Override
    public void requireChar(char c) {
        JsonTokenizer.requireChar$(this, c);
    }

    @Override
    public Nothing$ fail(String target, JsonLocation location, char errorChar) {
        return JsonTokenizer.fail$(this, target, location, errorChar);
    }

    @Override
    public JsonLocation fail$default$2() {
        return JsonTokenizer.fail$default$2$(this);
    }

    @Override
    public char fail$default$3() {
        return JsonTokenizer.fail$default$3$(this);
    }

    @Override
    public long cursorCharLocation() {
        return this.cursorCharLocation;
    }

    @Override
    public void cursorCharLocation_$eq(long x$1) {
        this.cursorCharLocation = x$1;
    }

    @Override
    public char cursorChar() {
        return this.cursorChar;
    }

    @Override
    public void cursorChar_$eq(char x$1) {
        this.cursorChar = x$1;
    }

    @Override
    public char[] strBuffer() {
        return this.strBuffer;
    }

    @Override
    public void org$mule$weave$v2$module$json$reader$JsonTokenizer$_setter_$strBuffer_$eq(char[] x$1) {
        this.strBuffer = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SourceReader input() {
        return this.input;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private TokenArray tokenBuffer() {
        return this.tokenBuffer;
    }

    private LocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public void addToken(long[] token, boolean putTokenInLC) {
        block0: {
            this.tokenBuffer().$plus$eq(token);
            if (!putTokenInLC) break block0;
            this.lcBuilder().addToken(token, this.tokenBuffer().length() - 1L);
        }
    }

    public Tuple3<Object, Object, String> readStringContent() {
        this.requireChar('\"');
        long start = this.cursorCharLocation();
        String str = this.parseString();
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)start), (Object)BoxesRunTime.boxToInteger((int)length), (Object)str);
    }

    public Tuple2<Object, Object> readString() {
        this.require('\"');
        long start = this.cursorCharLocation();
        while (this.readChar()) {
            this.advance();
        }
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple2.mcJI.sp(start, length);
    }

    public Tuple2<TokenArray, LocationCaches> tokens() {
        this.ws();
        this.readValue(true);
        LocationCaches locationCaches = (LocationCaches)this.ctx.registerCloseable((AutoCloseable)this.lcBuilder().build());
        this.ws();
        this.eof();
        return new Tuple2((Object)this.tokenBuffer(), (Object)locationCaches);
    }

    public Value<?> parse() {
        Tuple2<TokenArray, LocationCaches> tokens1 = this.tokens();
        return JsonRootValue$.MODULE$.apply((TokenArray)tokens1._1(), (LocationCaches)tokens1._2(), this.input(), this.name());
    }

    private void readValue(boolean putTokenInLC) {
        this.ws();
        long at = this.cursorCharLocation();
        char c = this.cursorChar();
        switch (c) {
            case 'f': {
                this.requireFalse();
                this.addToken(JsonTokenHelper$.MODULE$.createFalse(this.depth(), at), putTokenInLC);
                break;
            }
            case 't': {
                this.requireTrue();
                this.addToken(JsonTokenHelper$.MODULE$.createTrue(this.depth(), at), putTokenInLC);
                break;
            }
            case 'n': {
                this.requireNull();
                this.addToken(JsonTokenHelper$.MODULE$.createNull(this.depth(), at), putTokenInLC);
                break;
            }
            case '{': {
                this.inner(at, JsonTokenType$.MODULE$.ObjectStart(), JsonTokenType$.MODULE$.ObjectEnd(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readObject(), '}', putTokenInLC);
                break;
            }
            case '[': {
                this.inner(at, JsonTokenType$.MODULE$.ArrayStart(), JsonTokenType$.MODULE$.ArrayEnd(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readArray(), ']', putTokenInLC);
                break;
            }
            case '\"': {
                Tuple2<Object, Object> tuple2 = this.readString();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long offset = tuple2._1$mcJ$sp();
                int length = tuple2._2$mcI$sp();
                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(offset, length);
                Tuple2.mcJI.sp sp3 = sp2;
                long offset2 = sp3._1$mcJ$sp();
                int length2 = sp3._2$mcI$sp();
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.String(), this.depth(), offset2, length2), putTokenInLC);
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.Number(), this.depth(), at, this.readNumber()), putTokenInLC);
                break;
            }
            default: {
                throw this.fail(new StringBuilder(59).append("false or true or null or {...} or [...] or number but was ").append(this.cursorChar()).append(".").toString(), this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private int readNumber() {
        long start = this.cursorCharLocation();
        this.advanceIf('-');
        this.readInt();
        this.readFrac();
        this.readExp();
        return (int)(this.cursorCharLocation() - start);
    }

    private void readInt() {
        block0: {
            if (this.advanceIf('0')) break block0;
            this.readOneOrMoreDigits();
        }
    }

    private void readFrac() {
        block0: {
            if (!this.advanceIf('.')) break block0;
            this.readOneOrMoreDigits();
        }
    }

    private void readExp() {
        block0: {
            if (!this.advanceIf('e') && !this.advanceIf('E')) break block0;
            boolean bl = this.advanceIf('-') || this.advanceIf('+');
            this.readOneOrMoreDigits();
        }
    }

    private void readOneOrMoreDigits() {
        if (!this.readDigit()) {
            throw this.fail("readDigit", this.fail$default$2(), this.fail$default$3());
        }
        this.readZeroOrMoreDigits();
    }

    public final void readZeroOrMoreDigits() {
        while (this.readDigit()) {
        }
    }

    public boolean readDigit() {
        return this.cursorChar() >= '0' && this.cursorChar() <= '9' && this.advance();
    }

    private void inner(long at, int start, int end, Function0<BoxedUnit> inner, char req, boolean putTokenInLC) {
        long[] startToken = JsonTokenHelper$.MODULE$.create(start, this.depth(), at, 1L);
        this.addToken(startToken, putTokenInLC);
        this.advance();
        this.depth_$eq(this.depth() + 1);
        inner.apply$mcV$sp();
        this.depth_$eq(this.depth() - 1);
        this.ws();
        this.require(req);
    }

    private void readObject() {
        block0: {
            this.ws();
            if (this.cursorChar() == '}') break block0;
            this.readObjectMembers();
        }
    }

    private void readObjectMembers() {
        do {
            this.ws();
            Tuple3<Object, Object, String> tuple3 = this.readStringContent();
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
            int length = BoxesRunTime.unboxToInt((Object)tuple3._2());
            String keyName = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)offset), (Object)BoxesRunTime.boxToInteger((int)length), (Object)keyName);
            Tuple3 tuple33 = tuple32;
            long offset2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
            int length2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            String keyName2 = (String)tuple33._3();
            this.addToken(JsonTokenHelper$.MODULE$.createKey(keyName2, JsonTokenType$.MODULE$.Key(), this.depth(), offset2, length2), true);
            this.ws();
            this.require(':');
            this.ws();
            this.readValue(false);
        } while (this.ws(','));
    }

    private void readArray() {
        block0: {
            this.ws();
            if (this.cursorChar() == ']') break block0;
            this.values$1();
        }
    }

    private final void values$1() {
        do {
            this.readValue(true);
        } while (this.ws(','));
    }

    public IndexedJsonTokenizer(String name, SourceReader input, EvaluationContext ctx) {
        this.name = name;
        this.input = input;
        this.ctx = ctx;
        JsonTokenizer.$init$(this);
        this.depth = 0;
        this.tokenBuffer = (TokenArray)ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.lcBuilder = new LocationCacheBuilder(JsonTokenHelper$.MODULE$, ctx);
    }
}

