/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.mule.weave.v2.exception.UnsupportedBasePropertyException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.util.BinaryHelper$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;

public final class BinaryCoercer$
implements ValueCoercer<BinaryValue> {
    public static BinaryCoercer$ MODULE$;

    static {
        new BinaryCoercer$();
    }

    @Override
    public Option<BinaryValue> coerceMaybe(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetType, locationCapable, evaluationContext);
    }

    @Override
    public BinaryValue coerce(Value<?> c, Type targetType, LocationCapable locationCapable, EvaluationContext ctx) {
        Type type;
        Type type2;
        BinaryValue binaryValue;
        Type type3;
        Type type4 = c.valueType(ctx);
        if (type4 != null && (type3 = type4).isInstanceOf(BinaryType$.MODULE$, ctx)) {
            SeekableStream inputStream = (SeekableStream)c.evaluate(ctx);
            binaryValue = BinaryValue$.MODULE$.apply(inputStream, locationCapable, targetType, ctx);
        } else if (type4 != null && (type2 = type4).isInstanceOf(NumberType$.MODULE$, ctx)) {
            byte[] bytes = new byte[]{((Number)NumberType$.MODULE$.coerce(c, ctx).evaluate(ctx)).byteValue()};
            binaryValue = BinaryValue$.MODULE$.apply(bytes, locationCapable, targetType, ctx);
        } else if (type4 != null && (type = type4).isInstanceOf(StringType$.MODULE$, ctx)) {
            byte[] byArray;
            Option maybeBase = targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.base(ctx));
            if (maybeBase.isDefined()) {
                byte[] byArray2;
                String base = (String)maybeBase.get();
                String string = base;
                if ("64".equals(string)) {
                    String base64String = StringType$.MODULE$.coerce(c, ctx).evaluate(ctx).toString();
                    byArray2 = BinaryHelper$.MODULE$.fromBase64String(base64String, locationCapable);
                } else if ("16".equals(string)) {
                    byArray2 = BinaryHelper$.MODULE$.fromHexString(StringType$.MODULE$.coerce(c, ctx).evaluate(ctx).toString(), locationCapable);
                } else {
                    throw new UnsupportedBasePropertyException(((LocationCapable)((Schema)targetType.schema(ctx).get()).valueOf(Schema$.MODULE$.BASE_PROPERTY_NAME(), ctx).get()).location(), BinaryType$.MODULE$, StringType$.MODULE$, string, ctx);
                }
                byArray = byArray2;
            } else {
                try {
                    Charset charset = (Charset)targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.encoding(ctx).map((Function1 & Serializable & scala.Serializable)x$1 -> Charset.forName(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ctx.serviceManager().charsetProviderService().defaultCharset());
                    byArray = StringType$.MODULE$.coerce(c, ctx).evaluate(ctx).toString().getBytes(charset);
                }
                catch (UnsupportedCharsetException e) {
                    throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", (Option<String>)new Some((Object)new StringBuilder(24).append("Unsupported Charset: `").append(e.getMessage()).append("`.").toString()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                }
                catch (IllegalCharsetNameException e) {
                    throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", (Option<String>)new Some((Object)new StringBuilder(19).append("Illegal Charset:`").append(e.getMessage()).append("`.").toString()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                }
                catch (Throwable e) {
                    throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", (Option<String>)new Some((Object)e.getMessage()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                }
            }
            byte[] bytes = byArray;
            binaryValue = BinaryValue$.MODULE$.apply(bytes, locationCapable, targetType, ctx);
        } else {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(ctx), BinaryType$.MODULE$, c, ctx);
        }
        return binaryValue;
    }

    private BinaryCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
    }
}

