/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.CompositionBase;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Delta
extends CompositionBase
implements Graph {
    private Graph base;
    private Graph additions;
    private Graph deletions;

    public Delta(Graph base) {
        this.base = GraphPlain.plain(base);
        this.additions = GraphPlain.plain();
        this.deletions = GraphPlain.plain();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.base.getCapabilities();
    }

    public Graph getAdditions() {
        return this.additions;
    }

    public Graph getDeletions() {
        return this.deletions;
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.base.contains(t)) {
            this.additions.add(t);
        }
        this.deletions.delete(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.additions.delete(t);
        if (this.base.contains(t)) {
            this.deletions.add(t);
        }
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple t) {
        ExtendedIterator<Triple> iterator = this.base.find(t).filterDrop(Delta.ifIn(GraphUtil.findAll(this.deletions))).andThen(this.additions.find(t));
        return SimpleEventManager.notifyingRemove(this, iterator);
    }

    @Override
    public void close() {
        super.close();
        this.base.close();
        this.additions.close();
        this.deletions.close();
    }

    @Override
    public int graphBaseSize() {
        return this.base.size() + this.additions.size() - this.deletions.size();
    }
}

