/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.parser.spec.declaration;

import amf.core.errorhandling.ErrorHandler;
import amf.core.model.domain.AmfArray;
import amf.core.model.domain.AmfElement;
import amf.core.model.domain.AmfObject;
import amf.core.model.domain.AmfScalar;
import amf.core.parser.Annotations$;
import amf.core.parser.ScalarNode$;
import amf.core.parser.package$;
import amf.plugins.document.webapi.contexts.parser.oas.OasWebApiContext;
import amf.plugins.document.webapi.parser.spec.common.AnnotationParser;
import amf.plugins.document.webapi.parser.spec.common.AnnotationParser$;
import amf.plugins.document.webapi.parser.spec.common.OAuth2FlowValidations$;
import amf.plugins.document.webapi.parser.spec.declaration.Oas3SettingsProducers$;
import amf.plugins.document.webapi.parser.spec.declaration.OasLikeSecuritySettingsParser;
import amf.plugins.document.webapi.parser.spec.declaration.SettingsProducers;
import amf.plugins.domain.webapi.metamodel.security.HttpSettingsModel$;
import amf.plugins.domain.webapi.metamodel.security.OAuth2FlowModel$;
import amf.plugins.domain.webapi.metamodel.security.OAuth2SettingsModel$;
import amf.plugins.domain.webapi.metamodel.security.OpenIdConnectSettingsModel$;
import amf.plugins.domain.webapi.models.security.ApiKeySettings;
import amf.plugins.domain.webapi.models.security.HttpSettings;
import amf.plugins.domain.webapi.models.security.OAuth1Settings;
import amf.plugins.domain.webapi.models.security.OAuth2Flow;
import amf.plugins.domain.webapi.models.security.OAuth2Flow$;
import amf.plugins.domain.webapi.models.security.OAuth2Settings;
import amf.plugins.domain.webapi.models.security.OpenIdConnectSettings;
import amf.plugins.domain.webapi.models.security.SecurityScheme;
import amf.plugins.domain.webapi.models.security.Settings;
import java.io.Serializable;
import org.yaml.convert.YRead;
import org.yaml.model.IllegalTypeHandler;
import org.yaml.model.YMap;
import org.yaml.model.YMapEntry;
import org.yaml.model.YPart;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\u0007\u000e\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\b\u0001B\u0001B\u0003-\u0011\bC\u0003C\u0001\u0011\u00051\tC\u0003J\u0001\u0011\u0005#\nC\u0003U\u0001\u0011\u0005Q\u000bC\u0003\\\u0001\u0011\u0005A\fC\u0003b\u0001\u0011\u0005#\rC\u0003h\u0001\u0011%\u0001\u000eC\u0003s\u0001\u0011%1\u000fC\u0004\u0002\u000e\u0001!\t%a\u0004\u00035=\u000b7oM*fGV\u0014\u0018\u000e^=TKR$\u0018N\\4t!\u0006\u00148/\u001a:\u000b\u00059y\u0011a\u00033fG2\f'/\u0019;j_:T!\u0001E\t\u0002\tM\u0004Xm\u0019\u0006\u0003%M\ta\u0001]1sg\u0016\u0014(B\u0001\u000b\u0016\u0003\u00199XMY1qS*\u0011acF\u0001\tI>\u001cW/\\3oi*\u0011\u0001$G\u0001\ba2,x-\u001b8t\u0015\u0005Q\u0012aA1nM\u000e\u00011C\u0001\u0001\u001e!\tqr$D\u0001\u000e\u0013\t\u0001SBA\u000fPCNd\u0015n[3TK\u000e,(/\u001b;z'\u0016$H/\u001b8hgB\u000b'o]3s\u0003\ri\u0017\r\u001d\t\u0003G)j\u0011\u0001\n\u0006\u0003K\u0019\nQ!\\8eK2T!a\n\u0015\u0002\te\fW\u000e\u001c\u0006\u0002S\u0005\u0019qN]4\n\u0005-\"#\u0001B-NCB\faa]2iK6,\u0007C\u0001\u00187\u001b\u0005y#B\u0001\u00192\u0003!\u0019XmY;sSRL(B\u0001\u001a4\u0003\u0019iw\u000eZ3mg*\u0011A\u0003\u000e\u0006\u0003k]\ta\u0001Z8nC&t\u0017BA\u001c0\u00059\u0019VmY;sSRL8k\u00195f[\u0016\f1a\u0019;y!\tQ\u0004)D\u0001<\u0015\taT(A\u0002pCNT!A\u0005 \u000b\u0005}\u001a\u0012\u0001C2p]R,\u0007\u0010^:\n\u0005\u0005[$\u0001E(bg^+'-\u00119j\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019Ai\u0012%\u0015\u0005\u00153\u0005C\u0001\u0010\u0001\u0011\u0015AD\u0001q\u0001:\u0011\u0015\tC\u00011\u0001#\u0011\u0015aC\u00011\u0001.\u0003\u0015\u0001\u0018M]:f)\u0005Y\u0005c\u0001'P#6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0004PaRLwN\u001c\t\u0003]IK!aU\u0018\u0003\u0011M+G\u000f^5oON\f!\u0004]1sg\u0016|\u0005/\u001a8JI\u000e{gN\\3diN+G\u000f^5oON$\"AV-\u0011\u00059:\u0016B\u0001-0\u0005Uy\u0005/\u001a8JI\u000e{gN\\3diN+G\u000f^5oONDQA\u0017\u0004A\u0002Y\u000b\u0001b]3ui&twm]\u0001\u0012a\u0006\u00148/\u001a%uiB\u001cV\r\u001e;j]\u001e\u001cHCA/a!\tqc,\u0003\u0002`_\ta\u0001\n\u001e;q'\u0016$H/\u001b8hg\")!l\u0002a\u0001;\u0006\u0019\u0002/\u0019:tK>\u000bW\u000f\u001e53'\u0016$H/\u001b8hgR\u00111M\u001a\t\u0003]\u0011L!!Z\u0018\u0003\u001d=\u000bU\u000f\u001e53'\u0016$H/\u001b8hg\")!\f\u0003a\u0001G\u0006Q\u0001/\u0019:tK\u001acwn^:\u0015\u0007%d\u0017\u000f\u0005\u0002MU&\u00111.\u0014\u0002\u0005+:LG\u000fC\u0003n\u0013\u0001\u0007a.A\u0003f]R\u0014\u0018\u0010\u0005\u0002$_&\u0011\u0001\u000f\n\u0002\n36\u000b\u0007/\u00128uefDQAW\u0005A\u0002\r\f\u0011\u0002]1sg\u00164En\\<\u0015\tQ<\u0018\u0011\u0002\t\u0003]UL!A^\u0018\u0003\u0015=\u000bU\u000f\u001e53\r2|w\u000fC\u0003y\u0015\u0001\u0007\u00110\u0001\u0004qCJ,g\u000e\u001e\t\u0004u\u0006\raBA>\u0000!\taX*D\u0001~\u0015\tq8$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003i\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!AB*ue&twMC\u0002\u0002\u00025Ca!a\u0003\u000b\u0001\u0004q\u0017!\u00034m_^,e\u000e\u001e:z\u0003}1XM\u001c3peN\u0003XmY5gS\u000e\u001cV\r\u001e;j]\u001e\u001c\bK]8ek\u000e,'o\u001d\u000b\u0003\u0003#\u00012AHA\n\u0013\r\t)\"\u0004\u0002\u0012'\u0016$H/\u001b8hgB\u0013x\u000eZ;dKJ\u001c\b")
public class Oas3SecuritySettingsParser
extends OasLikeSecuritySettingsParser {
    private final YMap map;
    private final OasWebApiContext ctx;

    @Override
    public Option<Settings> parse() {
        return this.produceSettings().map((Function1 & Serializable & scala.Serializable)settings -> {
            Settings settings2;
            Settings settings3 = settings;
            if (settings3 instanceof OAuth1Settings) {
                OAuth1Settings oAuth1Settings = (OAuth1Settings)settings3;
                settings2 = this.parseOauth1Settings(oAuth1Settings);
            } else if (settings3 instanceof OAuth2Settings) {
                OAuth2Settings oAuth2Settings = (OAuth2Settings)settings3;
                settings2 = this.parseOauth2Settings(oAuth2Settings);
            } else if (settings3 instanceof ApiKeySettings) {
                ApiKeySettings apiKeySettings = (ApiKeySettings)settings3;
                settings2 = this.parseApiKeySettings(apiKeySettings);
            } else if (settings3 instanceof OpenIdConnectSettings) {
                OpenIdConnectSettings openIdConnectSettings = (OpenIdConnectSettings)settings3;
                settings2 = this.parseOpenIdConnectSettings(openIdConnectSettings);
            } else if (settings3 instanceof HttpSettings) {
                HttpSettings httpSettings = (HttpSettings)settings3;
                settings2 = this.parseHttpSettings(httpSettings);
            } else {
                settings2 = (Settings)package$.MODULE$.YMapOps($this.map).key(amf.core.utils.package$.MODULE$.AmfStrings("settings").asOasExtension()).map((Function1 & Serializable & scala.Serializable)entry -> this.parseDynamicSettings((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)$this.ctx), settings3, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]))).getOrElse((Function0 & Serializable & scala.Serializable)() -> settings3);
            }
            OAuth1Settings parsedSettings = settings2;
            return this.parseAnnotations(parsedSettings);
        });
    }

    public OpenIdConnectSettings parseOpenIdConnectSettings(OpenIdConnectSettings settings) {
        package$.MODULE$.YMapOps(this.map).key("openIdConnectUrl", (Function1)this.FieldOps(OpenIdConnectSettingsModel$.MODULE$.Url(), this.ctx).in(settings));
        package$.MODULE$.YMapOps(this.map).key(amf.core.utils.package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1 & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx), settings, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            return BoxedUnit.UNIT;
        });
        return settings;
    }

    public HttpSettings parseHttpSettings(HttpSettings settings) {
        package$.MODULE$.YMapOps(this.map).key("scheme", (Function1)this.FieldOps(HttpSettingsModel$.MODULE$.Scheme(), this.ctx).in(settings));
        package$.MODULE$.YMapOps(this.map).key("bearerFormat", (Function1)this.FieldOps(HttpSettingsModel$.MODULE$.BearerFormat(), this.ctx).in(settings));
        return settings;
    }

    @Override
    public OAuth2Settings parseOauth2Settings(OAuth2Settings settings) {
        package$.MODULE$.YMapOps(this.map).key("flows", (Function1 & Serializable & scala.Serializable)x$1 -> {
            this.parseFlows(x$1, settings);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.YMapOps(this.map).key(amf.core.utils.package$.MODULE$.AmfStrings("settings").asOasExtension(), (Function1 & Serializable & scala.Serializable)entry -> {
            this.parseDynamicSettings((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx), settings, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"authorizationGrants"}));
            return BoxedUnit.UNIT;
        });
        new AnnotationParser((AmfObject)settings, this.map, AnnotationParser$.MODULE$.apply$default$3(), this.ctx).parseOrphanNode("flows");
        return settings;
    }

    private void parseFlows(YMapEntry entry, OAuth2Settings settings) {
        IndexedSeq flows = (IndexedSeq)((YMap)entry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx)).entries().map((Function1 & Serializable & scala.Serializable)x$2 -> this.parseFlow(settings.id(), (YMapEntry)x$2), IndexedSeq$.MODULE$.canBuildFrom());
        settings.set(OAuth2SettingsModel$.MODULE$.Flows(), (AmfElement)new AmfArray((Seq)flows, Annotations$.MODULE$.apply((YPart)entry.value())), Annotations$.MODULE$.apply((YPart)entry));
    }

    /*
     * WARNING - void declaration
     */
    private OAuth2Flow parseFlow(String parent, YMapEntry flowEntry) {
        void var3_3;
        OAuth2Flow flow = OAuth2Flow$.MODULE$.apply((YPart)flowEntry);
        YMap flowMap = (YMap)flowEntry.value().as((YRead)YRead.YMapYRead$.MODULE$, (IllegalTypeHandler)this.ctx);
        AmfScalar flowKey = (AmfScalar)ScalarNode$.MODULE$.apply(flowEntry.key(), (IllegalTypeHandler)this.ctx).string();
        flow.set(OAuth2FlowModel$.MODULE$.Flow(), (AmfElement)flowKey, Annotations$.MODULE$.apply((YPart)flowEntry.key()));
        flow.adopted(parent, flow.adopted$default$2());
        package$.MODULE$.YMapOps(flowMap).key("authorizationUrl", (Function1)this.FieldOps(OAuth2FlowModel$.MODULE$.AuthorizationUri(), this.ctx).in(flow));
        package$.MODULE$.YMapOps(flowMap).key("tokenUrl", (Function1)this.FieldOps(OAuth2FlowModel$.MODULE$.AccessTokenUri(), this.ctx).in(flow));
        package$.MODULE$.YMapOps(flowMap).key("refreshUrl", (Function1)this.FieldOps(OAuth2FlowModel$.MODULE$.RefreshUri(), this.ctx).in(flow));
        this.parseScopes(flow, flowMap);
        OAuth2FlowValidations$.MODULE$.validateFlowFields(flow, (ErrorHandler)this.ctx.eh(), (YPart)flowEntry);
        this.ctx.closedShape(flow.id(), flowMap, flow.flow().value());
        return var3_3;
    }

    @Override
    public SettingsProducers vendorSpecificSettingsProducers() {
        return Oas3SettingsProducers$.MODULE$;
    }

    public Oas3SecuritySettingsParser(YMap map, SecurityScheme scheme, OasWebApiContext ctx) {
        this.map = map;
        this.ctx = ctx;
        super(map, scheme, ctx);
    }
}

